/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blocks;

import buildcraft.api.blocks.ICustomRotationHandler;
import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public enum CustomRotationHelper {
    INSTANCE;

    private static final boolean DEBUG;
    private final Map<Block, List<ICustomRotationHandler>> handlers = Maps.newIdentityHashMap();

    public void registerHandlerForAll(Class<? extends Block> blockClass, ICustomRotationHandler handler) {
        for (Block block : Block.field_149771_c) {
            Class<?> foundClass = block.getClass();
            if (!blockClass.isAssignableFrom(foundClass)) continue;
            if (DEBUG) {
                BCLog.logger.info("[api.rotation] Found an assignable block " + block.getRegistryName() + " (" + foundClass + ") for " + blockClass);
            }
            this.registerHandlerInternal(block, handler);
        }
    }

    public void registerHandler(Block block, ICustomRotationHandler handler) {
        if (this.registerHandlerInternal(block, handler)) {
            if (DEBUG) {
                BCLog.logger.info("[api.rotation] Setting a rotation handler for block " + block.getRegistryName());
            }
        } else if (DEBUG) {
            BCLog.logger.info("[api.rotation] Adding another rotation handler for block " + block.getRegistryName());
        }
    }

    private boolean registerHandlerInternal(Block block, ICustomRotationHandler handler) {
        if (!this.handlers.containsKey(block)) {
            ArrayList forBlock = Lists.newArrayList();
            forBlock.add(handler);
            this.handlers.put(block, forBlock);
            return true;
        }
        this.handlers.get(block).add(handler);
        return false;
    }

    public EnumActionResult attemptRotateBlock(World world, BlockPos pos, IBlockState state, EnumFacing sideWrenched) {
        Block block = state.func_177230_c();
        if (block instanceof ICustomRotationHandler) {
            return ((ICustomRotationHandler)block).attemptRotation(world, pos, state, sideWrenched);
        }
        if (!this.handlers.containsKey(block)) {
            return EnumActionResult.PASS;
        }
        for (ICustomRotationHandler handler : this.handlers.get(block)) {
            EnumActionResult result = handler.attemptRotation(world, pos, state, sideWrenched);
            if (result == EnumActionResult.PASS) continue;
            return result;
        }
        return EnumActionResult.PASS;
    }

    static {
        DEBUG = BCDebugging.shouldDebugLog("api.rotation");
    }
}

