/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.snapshot;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.template.TemplateApi;
import buildcraft.builders.snapshot.ITileForTemplateBuilder;
import buildcraft.builders.snapshot.SnapshotBuilder;
import buildcraft.builders.snapshot.Template;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;

public class TemplateBuilder
extends SnapshotBuilder<ITileForTemplateBuilder> {
    public TemplateBuilder(ITileForTemplateBuilder tile) {
        super(tile);
    }

    @Override
    protected Template.BuildingInfo getBuildingInfo() {
        return ((ITileForTemplateBuilder)this.tile).getTemplateBuildingInfo();
    }

    @Override
    protected boolean isAir(BlockPos blockPos) {
        return !this.getBuildingInfo().box.contains(blockPos) || !this.getBuildingInfo().getSnapshot().data.get(this.getBuildingInfo().getSnapshot().posToIndex(this.getBuildingInfo().fromWorld(blockPos)));
    }

    @Override
    protected boolean canPlace(BlockPos blockPos) {
        return ((ITileForTemplateBuilder)this.tile).getWorldBC().func_175623_d(blockPos);
    }

    @Override
    protected boolean isReadyToPlace(BlockPos blockPos) {
        return true;
    }

    @Override
    protected boolean hasEnoughToPlaceItems(BlockPos blockPos) {
        return !((ITileForTemplateBuilder)this.tile).getInvResources().extract(null, 1, 1, true).func_190926_b();
    }

    @Override
    protected List<ItemStack> getToPlaceItems(BlockPos blockPos) {
        return Collections.singletonList(((ITileForTemplateBuilder)this.tile).getInvResources().extract(null, 1, 1, false));
    }

    @Override
    protected boolean doPlaceTask(SnapshotBuilder.PlaceTask placeTask) {
        FakePlayer fakePlayer = BuildCraftAPI.fakePlayerProvider.getFakePlayer((WorldServer)((ITileForTemplateBuilder)this.tile).getWorldBC(), ((ITileForTemplateBuilder)this.tile).getOwner(), ((ITileForTemplateBuilder)this.tile).getBuilderPos());
        fakePlayer.func_184611_a(fakePlayer.func_184600_cs(), placeTask.items.get(0));
        return TemplateApi.templateRegistry.handle(((ITileForTemplateBuilder)this.tile).getWorldBC(), placeTask.pos, (EntityPlayer)fakePlayer, placeTask.items.get(0));
    }

    @Override
    protected void cancelPlaceTask(SnapshotBuilder.PlaceTask placeTask) {
        super.cancelPlaceTask(placeTask);
        ((ITileForTemplateBuilder)this.tile).getInvResources().insert(placeTask.items.get(0), false, false);
    }

    @Override
    protected boolean isBlockCorrect(BlockPos blockPos) {
        return !this.isAir(blockPos) && !((ITileForTemplateBuilder)this.tile).getWorldBC().func_175623_d(blockPos);
    }
}

