/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker.volume;

import buildcraft.core.marker.volume.VolumeBox;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.lang3.tuple.Pair;

public enum EnumAddonSlot {
    EAST_UP_SOUTH(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE),
    EAST_UP_NORTH(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE),
    EAST_DOWN_SOUTH(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE),
    EAST_DOWN_NORTH(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE),
    WEST_UP_SOUTH(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE),
    WEST_UP_NORTH(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE),
    WEST_DOWN_SOUTH(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE),
    WEST_DOWN_NORTH(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE);

    public static final EnumAddonSlot[] VALUES;
    public final Map<EnumFacing.Axis, EnumFacing.AxisDirection> directions = new EnumMap<EnumFacing.Axis, EnumFacing.AxisDirection>(EnumFacing.Axis.class);

    private EnumAddonSlot(EnumFacing.AxisDirection x, EnumFacing.AxisDirection y, EnumFacing.AxisDirection z) {
        this.directions.put(EnumFacing.Axis.X, x);
        this.directions.put(EnumFacing.Axis.Y, y);
        this.directions.put(EnumFacing.Axis.Z, z);
    }

    public AxisAlignedBB getBoundingBox(VolumeBox volumeBox) {
        AxisAlignedBB aabb = volumeBox.box.getBoundingBox();
        Vec3d boxOffset = new Vec3d(this.directions.get(EnumFacing.Axis.X) == EnumFacing.AxisDirection.POSITIVE ? aabb.field_72336_d : aabb.field_72340_a, this.directions.get(EnumFacing.Axis.Y) == EnumFacing.AxisDirection.POSITIVE ? aabb.field_72337_e : aabb.field_72338_b, this.directions.get(EnumFacing.Axis.Z) == EnumFacing.AxisDirection.POSITIVE ? aabb.field_72334_f : aabb.field_72339_c);
        return new AxisAlignedBB(boxOffset.field_72450_a, boxOffset.field_72448_b, boxOffset.field_72449_c, boxOffset.field_72450_a, boxOffset.field_72448_b, boxOffset.field_72449_c).func_186662_g(0.0625);
    }

    public static Pair<VolumeBox, EnumAddonSlot> getSelectingVolumeBoxAndSlot(EntityPlayer player, List<VolumeBox> volumeBoxes) {
        Vec3d start = player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3d end = start.func_178787_e(player.func_70040_Z().func_186678_a(4.0));
        VolumeBox bestVolumeBox = null;
        EnumAddonSlot bestSlot = null;
        double bestDist = Double.MAX_VALUE;
        for (VolumeBox volumeBox : volumeBoxes) {
            for (EnumAddonSlot slot : EnumAddonSlot.values()) {
                double dist;
                RayTraceResult ray = slot.getBoundingBox(volumeBox).func_72327_a(start, end);
                if (ray == null || !(bestDist > (dist = ray.field_72307_f.func_72438_d(start)))) continue;
                bestDist = dist;
                bestVolumeBox = volumeBox;
                bestSlot = slot;
            }
        }
        return Pair.of(bestVolumeBox, bestSlot);
    }

    static {
        VALUES = EnumAddonSlot.values();
    }
}

