/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.zone;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.util.math.ChunkPos;

public class ZonePlannerMapChunkKey {
    public static final int LEVEL_HEIGHT = 32;
    public final ChunkPos chunkPos;
    public final int dimensionalId;
    public final int level;
    private final int hash;

    public ZonePlannerMapChunkKey(ChunkPos chunkPos, int dimensionalId, int level) {
        this.chunkPos = chunkPos;
        this.dimensionalId = dimensionalId;
        this.level = level;
        this.hash = Arrays.hashCode(new int[]{chunkPos.field_77276_a, chunkPos.field_77275_b, dimensionalId, level});
    }

    public ZonePlannerMapChunkKey(ByteBuf buf) {
        this.chunkPos = new ChunkPos(buf.readInt(), buf.readInt());
        this.dimensionalId = buf.readInt();
        this.level = buf.readInt();
        this.hash = Arrays.hashCode(new int[]{this.chunkPos.field_77276_a, this.chunkPos.field_77275_b, this.dimensionalId, this.level});
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.chunkPos.field_77276_a);
        buf.writeInt(this.chunkPos.field_77275_b);
        buf.writeInt(this.dimensionalId);
        buf.writeInt(this.level);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ZonePlannerMapChunkKey other = (ZonePlannerMapChunkKey)o;
        if (this.dimensionalId != other.dimensionalId) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        return this.chunkPos.field_77276_a == other.chunkPos.field_77276_a && this.chunkPos.field_77275_b == other.chunkPos.field_77275_b;
    }

    public int hashCode() {
        return this.hash;
    }
}

