/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.overlay;

import mcp.mobius.waila.api.event.WailaRenderEvent;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.config.OverlayConfig;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.overlay.RayTracing;
import mcp.mobius.waila.overlay.Tooltip;
import mcp.mobius.waila.overlay.WailaTickHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.opengl.GL11;

public class OverlayRenderer {
    protected static boolean hasLight;
    protected static boolean hasDepthTest;
    protected static boolean hasLight0;
    protected static boolean hasLight1;
    protected static boolean hasRescaleNormal;
    protected static boolean hasColorMaterial;
    protected static boolean depthMask;
    protected static int depthFunc;

    public static void renderOverlay() {
        if (WailaTickHandler.instance().tooltip == null) {
            return;
        }
        if (!ConfigHandler.instance().showTooltip()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null || mc.field_71441_e == null) {
            return;
        }
        if (ConfigHandler.instance().hideFromList() && mc.field_71474_y.field_74321_H.func_151470_d() && !mc.func_71387_A()) {
            return;
        }
        if (!Minecraft.func_71382_s()) {
            return;
        }
        if (mc.field_71474_y.field_74330_P && ConfigHandler.instance().hideFromDebug()) {
            return;
        }
        if (RayTracing.instance().getTarget() == null) {
            return;
        }
        if (RayTracing.instance().getTarget().field_72313_a == RayTraceResult.Type.BLOCK && !RayTracing.instance().getTargetStack().func_190926_b()) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip);
        }
        if (RayTracing.instance().getTarget().field_72313_a == RayTraceResult.Type.ENTITY && ConfigHandler.instance().getConfig("general.showents")) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltip);
        }
    }

    public static void renderOverlay(Tooltip tooltip) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("Waila Overlay");
        GlStateManager.func_179094_E();
        OverlayRenderer.saveGLState();
        GlStateManager.func_179152_a((float)OverlayConfig.scale, (float)OverlayConfig.scale, (float)1.0f);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        WailaRenderEvent.Pre event = new WailaRenderEvent.Pre(DataAccessorCommon.instance, tooltip.x, tooltip.y, tooltip.w, tooltip.h);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179091_B();
            OverlayRenderer.loadGLState();
            GlStateManager.func_179126_j();
            GlStateManager.func_179121_F();
            return;
        }
        OverlayRenderer.drawTooltipBox(event.getX(), event.getY(), event.getWidth(), event.getHeight(), OverlayConfig.bgcolor, OverlayConfig.gradient1, OverlayConfig.gradient2);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        tooltip.draw();
        GlStateManager.func_179084_k();
        tooltip.draw2nd();
        if (tooltip.hasIcon()) {
            RenderHelper.func_74520_c();
        }
        GlStateManager.func_179091_B();
        if (tooltip.hasIcon() && !tooltip.stack.func_190926_b()) {
            DisplayUtil.renderStack(event.getX() + 5, event.getY() + event.getHeight() / 2 - 8, tooltip.stack);
        }
        MinecraftForge.EVENT_BUS.post((Event)new WailaRenderEvent.Post(event.getX(), event.getY(), event.getWidth(), event.getHeight()));
        OverlayRenderer.loadGLState();
        GlStateManager.func_179126_j();
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public static void saveGLState() {
        hasLight = GL11.glGetBoolean((int)2896);
        hasLight0 = GL11.glGetBoolean((int)16384);
        hasLight1 = GL11.glGetBoolean((int)16385);
        hasDepthTest = GL11.glGetBoolean((int)2929);
        hasRescaleNormal = GL11.glGetBoolean((int)32826);
        hasColorMaterial = GL11.glGetBoolean((int)2903);
        depthFunc = GL11.glGetInteger((int)2932);
        depthMask = GL11.glGetBoolean((int)2930);
        GL11.glPushAttrib((int)1);
    }

    public static void loadGLState() {
        GlStateManager.func_179132_a((boolean)depthMask);
        GlStateManager.func_179143_c((int)depthFunc);
        if (hasLight) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
        if (hasLight0) {
            GlStateManager.func_179085_a((int)0);
        } else {
            GlStateManager.func_179122_b((int)0);
        }
        if (hasLight1) {
            GlStateManager.func_179085_a((int)1);
        } else {
            GlStateManager.func_179122_b((int)1);
        }
        if (hasDepthTest) {
            GlStateManager.func_179126_j();
        } else {
            GlStateManager.func_179097_i();
        }
        if (hasRescaleNormal) {
            GlStateManager.func_179091_B();
        } else {
            GlStateManager.func_179101_C();
        }
        if (hasColorMaterial) {
            GlStateManager.func_179142_g();
        } else {
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179099_b();
    }

    public static void drawTooltipBox(int x, int y, int w, int h, int bg, int grad1, int grad2) {
        DisplayUtil.drawGradientRect(x + 1, y, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + h, w - 1, 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + w, y + 1, 1, h - 1, bg, bg);
        DisplayUtil.drawGradientRect(x + 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + w - 1, y + 2, 1, h - 3, grad1, grad2);
        DisplayUtil.drawGradientRect(x + 1, y + 1, w - 1, 1, grad1, grad1);
        DisplayUtil.drawGradientRect(x + 1, y + h - 1, w - 1, 1, grad2, grad2);
    }
}

