/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.inventory;

import cofh.core.inventory.ComparableItemStackNBT;
import cofh.core.inventory.OreValidator;
import cofh.core.util.helpers.ItemHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class ComparableItemStackValidatedNBT
extends ComparableItemStackNBT {
    private final OreValidator validator;

    public ComparableItemStackValidatedNBT(ItemStack stack) {
        super(stack);
        this.validator = DEFAULT_VALIDATOR;
        this.oreID = this.getOreID(stack);
        this.oreName = ItemHelper.oreProxy.getOreName(this.oreID);
    }

    public ComparableItemStackValidatedNBT(ItemStack stack, @Nonnull OreValidator validator) {
        super(stack);
        this.validator = validator;
        this.oreID = this.getOreID(stack);
        this.oreName = ItemHelper.oreProxy.getOreName(this.oreID);
    }

    public int getOreID(ItemStack stack) {
        List<Integer> ids = ItemHelper.oreProxy.getAllOreIDs(stack);
        if (!ids.isEmpty()) {
            for (Integer id : ids) {
                if (id == -1 || !this.validator.validate(ItemHelper.oreProxy.getOreName(id))) continue;
                return id;
            }
        }
        return -1;
    }

    public int getOreID(String oreName) {
        if (!this.validator.validate(oreName)) {
            return -1;
        }
        return ItemHelper.oreProxy.getOreID(oreName);
    }
}

