/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.commands;

import com.google.gson.Gson;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.command.impl.LootCommand;
import net.minecraft.loot.LootSerializers;
import net.minecraft.loot.LootTable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.loading.FMLPaths;

public class SerializeLootTableCommand {
    public static final Gson GSON = LootSerializers.func_237388_c_().setPrettyPrinting().create();
    public static final DynamicCommandExceptionType NOT_FOUND = new DynamicCommandExceptionType(arg -> new TranslationTextComponent("placebo.cmd.not_found", new Object[]{arg}));

    public static void register(LiteralArgumentBuilder<CommandSource> builder) {
        builder.then(Commands.func_197057_a((String)"serialize_loot_table").then(Commands.func_197056_a((String)"loot_table", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(LootCommand.field_218904_a).executes(ctx -> {
            ResourceLocation id = ResourceLocationArgument.func_197195_e((CommandContext)ctx, (String)"loot_table");
            LootTable table = ((CommandSource)ctx.getSource()).func_197028_i().func_200249_aQ().func_186521_a(id);
            if (table == LootTable.field_186464_a) {
                throw NOT_FOUND.create((Object)id);
            }
            String path = "placebo_serialized/" + id.func_110624_b() + "/loot_tables/" + id.func_110623_a() + ".json";
            File file = new File(FMLPaths.GAMEDIR.get().toFile(), path);
            file.getParentFile().mkdirs();
            if (SerializeLootTableCommand.attemptSerialize(table, file)) {
                ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("placebo.cmd.serialize_success", new Object[]{id, path}), true);
            } else {
                ((CommandSource)ctx.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("placebo.cmd.serialize_failure"));
            }
            return 0;
        })));
    }

    public static boolean attemptSerialize(LootTable table, File file) {
        String json = GSON.toJson((Object)table);
        try (FileWriter w = new FileWriter(file);){
            w.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

