/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import com.supermartijn642.core.ClientUtils;
import java.text.NumberFormat;

public class EnergyFormat {
    private static EnergyType type = EnergyType.RF;

    public static void cycleEnergyType(boolean forward) {
        type = EnergyType.values()[(type.ordinal() + (forward ? 1 : EnergyType.values().length - 1)) % EnergyType.values().length];
    }

    public static String formatEnergy(int energy) {
        return type.convertEnergy(energy);
    }

    public static String formatUnit() {
        return type.getUnit();
    }

    public static String formatUnitPerTick() {
        return type.unit + "/t";
    }

    private static enum EnergyType {
        FE("FE"),
        RF("RF");

        private final String unit;

        private EnergyType(String unit) {
            this.unit = unit;
        }

        public String getUnit() {
            return this.unit;
        }

        public String convertEnergy(int energy) {
            return NumberFormat.getNumberInstance(ClientUtils.getMinecraft().func_135016_M().func_135041_c().getJavaLocale()).format(energy);
        }
    }
}

