/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class ScreenUtils {
    private static final ResourceLocation BUTTON_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/buttons.png");
    private static final ResourceLocation SCREEN_BACKGROUND = new ResourceLocation("supermartijn642corelib", "textures/gui/background.png");
    public static final int DEFAULT_TEXT_COLOR = 0x404040;
    public static final int ACTIVE_TEXT_COLOR = 0xE0E0E0;
    public static final int INACTIVE_TEXT_COLOR = 0x707070;

    public static void drawString(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        fontRenderer.func_243248_b(matrixStack, text, x, y, color);
    }

    public static void drawString(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        fontRenderer.func_243248_b(matrixStack, text, x, y, 0x404040);
    }

    public static void drawString(MatrixStack matrixStack, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawString(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(MatrixStack matrixStack, ITextComponent text, float x, float y) {
        ScreenUtils.drawString(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        fontRenderer.func_243246_a(matrixStack, text, x, y, color);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        fontRenderer.func_243246_a(matrixStack, text, x, y, 0x404040);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, ITextComponent text, float x, float y) {
        ScreenUtils.drawStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        fontRenderer.func_243248_b(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, color);
    }

    public static void drawCenteredString(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        fontRenderer.func_243248_b(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredString(MatrixStack matrixStack, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(MatrixStack matrixStack, ITextComponent text, float x, float y) {
        ScreenUtils.drawCenteredString(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y, int color) {
        fontRenderer.func_243246_a(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, float x, float y) {
        fontRenderer.func_243246_a(matrixStack, text, x - (float)fontRenderer.func_238414_a_((ITextProperties)text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, ITextComponent text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, ITextComponent text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawString(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_238421_b_(matrixStack, text, x, y, color);
    }

    public static void drawString(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y) {
        fontRenderer.func_238421_b_(matrixStack, text, x, y, 0x404040);
    }

    public static void drawString(MatrixStack matrixStack, String text, float x, float y, int color) {
        ScreenUtils.drawString(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawString(MatrixStack matrixStack, String text, float x, float y) {
        ScreenUtils.drawString(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_238405_a_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y) {
        fontRenderer.func_238405_a_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, 0x404040);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, String text, float x, float y, int color) {
        ScreenUtils.drawStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawStringWithShadow(MatrixStack matrixStack, String text, float x, float y) {
        ScreenUtils.drawStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredString(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_238421_b_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawCenteredString(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y) {
        fontRenderer.func_238421_b_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredString(MatrixStack matrixStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredString(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredString(MatrixStack matrixStack, String text, float x, float y) {
        ScreenUtils.drawCenteredString(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y, int color) {
        fontRenderer.func_238405_a_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, color);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, float x, float y) {
        fontRenderer.func_238405_a_(matrixStack, text, x - (float)fontRenderer.func_78256_a(text) / 2.0f, y, 0x404040);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, String text, float x, float y, int color) {
        ScreenUtils.drawCenteredStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y, color);
    }

    public static void drawCenteredStringWithShadow(MatrixStack matrixStack, String text, float x, float y) {
        ScreenUtils.drawCenteredStringWithShadow(matrixStack, ClientUtils.getFontRenderer(), text, x, y);
    }

    public static void drawScreenBackground(MatrixStack matrixStack, float x, float y, float width, float height) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(SCREEN_BACKGROUND);
        ScreenUtils.drawTexture(matrixStack, x, y, 4.0f, 4.0f, 0.0f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x + width - 4.0f, y, 4.0f, 4.0f, 0.5555556f, 0.0f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x + width - 4.0f, y + height - 4.0f, 4.0f, 4.0f, 0.5555556f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x, y + height - 4.0f, 4.0f, 4.0f, 0.0f, 0.5555556f, 0.44444445f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x + 4.0f, y, width - 8.0f, 4.0f, 0.44444445f, 0.0f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x + 4.0f, y + height - 4.0f, width - 8.0f, 4.0f, 0.44444445f, 0.5555556f, 0.11111111f, 0.44444445f);
        ScreenUtils.drawTexture(matrixStack, x, y + 4.0f, 4.0f, height - 8.0f, 0.0f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(matrixStack, x + width - 4.0f, y + 4.0f, 4.0f, height - 8.0f, 0.5555556f, 0.44444445f, 0.44444445f, 0.11111111f);
        ScreenUtils.drawTexture(matrixStack, x + 4.0f, y + 4.0f, width - 8.0f, height - 8.0f, 0.44444445f, 0.44444445f, 0.11111111f, 0.11111111f);
    }

    public static void drawButtonBackground(MatrixStack matrixStack, float x, float y, float width, float height, float yOffset) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BUTTON_BACKGROUND);
        ScreenUtils.drawTexture(matrixStack, x, y, 2.0f, 2.0f, 0.0f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x + width - 2.0f, y, 2.0f, 2.0f, 0.6f, yOffset, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x + width - 2.0f, y + height - 2.0f, 2.0f, 2.0f, 0.6f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x, y + height - 2.0f, 2.0f, 2.0f, 0.0f, yOffset + 0.2f, 0.4f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x + 2.0f, y, width - 4.0f, 2.0f, 0.4f, yOffset, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x + 2.0f, y + height - 2.0f, width - 4.0f, 2.0f, 0.4f, yOffset + 0.2f, 0.2f, 0.13333334f);
        ScreenUtils.drawTexture(matrixStack, x, y + 2.0f, 2.0f, height - 4.0f, 0.0f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(matrixStack, x + width - 2.0f, y + 2.0f, 2.0f, height - 4.0f, 0.6f, yOffset + 0.13333334f, 0.4f, 0.06666667f);
        ScreenUtils.drawTexture(matrixStack, x + 2.0f, y + 2.0f, width - 4.0f, height - 4.0f, 0.4f, yOffset + 0.13333334f, 0.2f, 0.06666667f);
    }

    public static void drawTexture(MatrixStack matrixStack, float x, float y, float width, float height) {
        ScreenUtils.drawTexture(matrixStack, x, y, width, height, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void drawTexture(MatrixStack matrixStack, float x, float y, float width, float height, float tx, float ty, float twidth, float theight) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, x, y + height, 0.0f).func_225583_a_(tx, ty + theight).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(tx + twidth, ty + theight).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, 0.0f).func_225583_a_(tx + twidth, ty).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, 0.0f).func_225583_a_(tx, ty).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void fillRect(MatrixStack matrixStack, float x, float y, float width, float height, int color) {
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        ScreenUtils.fillRect(matrixStack, x, y, width, height, red, green, blue, alpha);
    }

    public static void fillRect(MatrixStack matrixStack, float x, float y, float width, float height, float red, float green, float blue, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(matrix, x, y + height, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y + height, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, x + width, y, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
        buffer.func_227888_a_(matrix, x, y, 0.0f).func_227885_a_(red, green, blue, alpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void bindTexture(ResourceLocation location) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(location);
    }
}

