/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.block.BlockShape;
import java.util.OptionalDouble;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;

public class RenderUtils {
    private static final RenderState.LayerState VIEW_OFFSET_Z_LAYERING = new RenderState.LayerState("view_offset_z_layering", () -> {
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)0.99975586f, (float)0.99975586f, (float)0.99975586f);
    }, RenderSystem::popMatrix);
    private static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    private static final RenderType LINES_NO_DEPTH = RenderType.func_228632_a_((String)"supermartijn642corelib:highlight", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)128, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(1.0))).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228718_a_(VIEW_OFFSET_Z_LAYERING).func_228727_a_(new RenderState.WriteMaskState(true, false)).func_228715_a_(new RenderState.DepthTestState("no_depth", 519)).func_228728_a_(false));
    private static final IRenderTypeBuffer.Impl LINE_BUFFER = IRenderTypeBuffer.func_228455_a_((BufferBuilder)new BufferBuilder(128));

    public static void enableDepthTest() {
        GlStateManager.func_227734_k_();
    }

    public static void disableDepthTest() {
        GlStateManager.func_227731_j_();
    }

    public static Vector3d getCameraPosition() {
        return ClientUtils.getMinecraft().func_175598_ae().field_217783_c.func_216785_c();
    }

    public static void renderShape(MatrixStack matrixStack, BlockShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        matrixStack.func_227860_a_();
        Vector3d camera = RenderUtils.getCameraPosition();
        matrixStack.func_227861_a_(x - camera.field_72450_a, y - camera.field_72448_b, z - camera.field_72449_c);
        IVertexBuilder builder = LINE_BUFFER.getBuffer(LINES_NO_DEPTH);
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        shape.forEachEdge((x1, y1, z1, x2, y2, z2) -> {
            builder.func_227888_a_(matrix4f, (float)x1, (float)y1, (float)z1).func_227885_a_(red, green, blue, alpha).func_181675_d();
            builder.func_227888_a_(matrix4f, (float)x2, (float)y2, (float)z2).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
        LINE_BUFFER.func_228461_a_();
        matrixStack.func_227865_b_();
    }

    public static void renderShape(MatrixStack matrixStack, VoxelShape shape, double x, double y, double z, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(shape), x, y, z, red, green, blue, alpha);
    }

    public static void renderBox(MatrixStack matrixStack, AxisAlignedBB box, double x, double y, double z, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(box), x, y, z, red, green, blue, alpha);
    }

    public static void renderShape(MatrixStack matrixStack, BlockShape shape, BlockPos pos, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(matrixStack, shape, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), red, green, blue, alpha);
    }

    public static void renderShape(MatrixStack matrixStack, VoxelShape shape, BlockPos pos, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(shape), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), red, green, blue, alpha);
    }

    public static void renderBox(MatrixStack matrixStack, AxisAlignedBB box, BlockPos pos, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(box), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), red, green, blue, alpha);
    }

    public static void renderShape(MatrixStack matrixStack, BlockShape shape, double x, double y, double z, float red, float green, float blue) {
        RenderUtils.renderShape(matrixStack, shape, x, y, z, red, green, blue, 1.0f);
    }

    public static void renderShape(MatrixStack matrixStack, VoxelShape shape, double x, double y, double z, float red, float green, float blue) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(shape), x, y, z, red, green, blue, 1.0f);
    }

    public static void renderBox(MatrixStack matrixStack, AxisAlignedBB box, double x, double y, double z, float red, float green, float blue) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(box), x, y, z, red, green, blue, 1.0f);
    }

    public static void renderShape(MatrixStack matrixStack, BlockShape shape, BlockPos pos, float red, float green, float blue) {
        RenderUtils.renderShape(matrixStack, shape, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), red, green, blue, 1.0f);
    }

    public static void renderShape(MatrixStack matrixStack, VoxelShape shape, BlockPos pos, float red, float green, float blue) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(shape), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), red, green, blue);
    }

    public static void renderBox(MatrixStack matrixStack, AxisAlignedBB box, BlockPos pos, float red, float green, float blue) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(box), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), red, green, blue);
    }

    public static void renderShape(MatrixStack matrixStack, BlockShape shape, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(matrixStack, shape, 0.0, 0.0, 0.0, red, green, blue, alpha);
    }

    public static void renderShape(MatrixStack matrixStack, VoxelShape shape, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(shape), 0.0, 0.0, 0.0, red, green, blue, alpha);
    }

    public static void renderBox(MatrixStack matrixStack, AxisAlignedBB box, float red, float green, float blue, float alpha) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(box), 0.0, 0.0, 0.0, red, green, blue, alpha);
    }

    public static void renderShape(MatrixStack matrixStack, BlockShape shape, float red, float green, float blue) {
        RenderUtils.renderShape(matrixStack, shape, 0.0, 0.0, 0.0, red, green, blue, 1.0f);
    }

    public static void renderShape(MatrixStack matrixStack, VoxelShape shape, float red, float green, float blue) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(shape), 0.0, 0.0, 0.0, red, green, blue, 1.0f);
    }

    public static void renderBox(MatrixStack matrixStack, AxisAlignedBB box, float red, float green, float blue) {
        RenderUtils.renderShape(matrixStack, BlockShape.create(box), 0.0, 0.0, 0.0, red, green, blue, 1.0f);
    }
}

