/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.mixin;

import com.github.alexthe666.citadel.server.entity.ICitadelDataEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ICitadelDataEntity {
    private static final DataParameter<CompoundNBT> CITADEL_DATA = EntityDataManager.func_187226_a(LivingEntity.class, (IDataSerializer)DataSerializers.field_192734_n);

    protected LivingEntityMixin(EntityType<? extends Entity> entityType, World world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"Lnet/minecraft/entity/LivingEntity;registerData()V"})
    private void citadel_registerData(CallbackInfo ci) {
        this.field_70180_af.func_187214_a(CITADEL_DATA, (Object)new CompoundNBT());
    }

    @Inject(at={@At(value="TAIL")}, method={"Lnet/minecraft/entity/LivingEntity;writeAdditional(Lnet/minecraft/nbt/CompoundNBT;)V"})
    private void citadel_writeAdditional(CompoundNBT compoundNBT, CallbackInfo ci) {
        CompoundNBT citadelDat = this.getCitadelEntityData();
        if (citadelDat != null) {
            compoundNBT.func_218657_a("CitadelData", (INBT)citadelDat);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"Lnet/minecraft/entity/LivingEntity;readAdditional(Lnet/minecraft/nbt/CompoundNBT;)V"})
    private void citadel_readAdditional(CompoundNBT compoundNBT, CallbackInfo ci) {
        if (compoundNBT.func_74764_b("CitadelData")) {
            this.setCitadelEntityData(compoundNBT.func_74775_l("CitadelData"));
        }
    }

    @Override
    public CompoundNBT getCitadelEntityData() {
        return (CompoundNBT)this.field_70180_af.func_187225_a(CITADEL_DATA);
    }

    @Override
    public void setCitadelEntityData(CompoundNBT nbt) {
        this.field_70180_af.func_187227_b(CITADEL_DATA, (Object)nbt);
    }
}

