/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterstrongholds.world.processor;

import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterstrongholds.BetterStrongholds;
import com.yungnickyoung.minecraft.betterstrongholds.init.BSModProcessors;
import com.yungnickyoung.minecraft.betterstrongholds.world.ItemFrameChances;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

@MethodsReturnNonnullByDefault
public class ItemFrameProcessor
extends StructureProcessor {
    public static final ItemFrameProcessor INSTANCE = new ItemFrameProcessor();
    public static final Codec<ItemFrameProcessor> CODEC = Codec.unit(() -> INSTANCE);

    @ParametersAreNonnullByDefault
    public Template.EntityInfo processEntity(IWorldReader world, BlockPos seedPos, Template.EntityInfo localEntityInfo, Template.EntityInfo globalEntityInfo, PlacementSettings placementSettings, Template template) {
        if (globalEntityInfo.field_186249_c.func_74779_i("id").equals("minecraft:item_frame")) {
            String randomItemString;
            String item;
            Random random = placementSettings.func_189947_a(globalEntityInfo.field_186248_b);
            try {
                item = globalEntityInfo.field_186249_c.func_74775_l("Item").func_74781_a("id").toString();
            }
            catch (Exception e) {
                BetterStrongholds.LOGGER.info("Unable to randmize item frame at {}", (Object)globalEntityInfo.field_186248_b);
                return globalEntityInfo;
            }
            CompoundNBT newNBT = globalEntityInfo.field_186249_c.func_74737_b();
            if (item.equals("\"minecraft:iron_sword\"")) {
                randomItemString = ItemFrameChances.get().getArmouryItem(random).getRegistryName().toString();
                if (!randomItemString.equals("minecraft:air")) {
                    newNBT.func_74775_l("Item").func_74778_a("id", randomItemString);
                }
            } else if (item.equals("\"minecraft:bread\"") && !(randomItemString = ItemFrameChances.get().getStorageItem(random).getRegistryName().toString()).equals("minecraft:air")) {
                newNBT.func_74775_l("Item").func_74778_a("id", randomItemString);
            }
            int randomRotation = random.nextInt(8);
            newNBT.func_74774_a("ItemRotation", (byte)randomRotation);
            globalEntityInfo = new Template.EntityInfo(globalEntityInfo.field_186247_a, globalEntityInfo.field_186248_b, newNBT);
        }
        return globalEntityInfo;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return BSModProcessors.ITEMFRAME_PROCESSOR;
    }
}

