/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.DecimalFormat;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ElementProgress
implements IElement {
    private final long current;
    private final long max;
    private final IProgressStyle style;
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    public ElementProgress(long current, long max, IProgressStyle style) {
        this.current = current;
        this.max = max;
        this.style = style;
    }

    public ElementProgress(PacketBuffer buf) {
        this.current = buf.readLong();
        this.max = buf.readLong();
        this.style = new ProgressStyle().width(buf.readInt()).height(buf.readInt()).prefix(buf.func_179258_d()).suffix(buf.func_179258_d()).borderColor(buf.readInt()).filledColor(buf.readInt()).alternateFilledColor(buf.readInt()).backgroundColor(buf.readInt()).showText(buf.readBoolean()).numberFormat(NumberFormat.values()[buf.readByte()]).lifeBar(buf.readBoolean()).armorBar(buf.readBoolean()).alignment((ElementAlignment)buf.func_179257_a(ElementAlignment.class));
    }

    public IProgressStyle getStyle() {
        return this.style;
    }

    public static ITextComponent format(long in, NumberFormat style, ITextComponent suffix) {
        switch (style) {
            case FULL: {
                return new StringTextComponent(Long.toString(in)).func_230529_a_(suffix);
            }
            case COMPACT: {
                if (in < 1000L) {
                    return new StringTextComponent(Long.toString(in) + " ").func_230529_a_(suffix);
                }
                int unit = 1000;
                int exp = (int)(Math.log(in) / Math.log(unit));
                String s = suffix.getString();
                if (s.startsWith("m")) {
                    s = s.substring(1);
                    if (exp - 2 >= 0) {
                        char pre = "kMGTPE".charAt(exp - 2);
                        return new StringTextComponent(String.format("%.1f %s", (double)in / Math.pow(unit, exp), Character.valueOf(pre))).func_230529_a_((ITextComponent)new StringTextComponent(s).func_240703_c_(suffix.func_150256_b()));
                    }
                    return new StringTextComponent(String.format("%.1f", (double)in / Math.pow(unit, exp))).func_230529_a_((ITextComponent)new StringTextComponent(s).func_240703_c_(suffix.func_150256_b()));
                }
                char pre = "kMGTPE".charAt(exp - 1);
                return new StringTextComponent(String.format("%.1f %s", (double)in / Math.pow(unit, exp), Character.valueOf(pre))).func_230529_a_(suffix);
            }
            case COMMAS: {
                return new StringTextComponent(dfCommas.format(in)).func_230529_a_(suffix);
            }
            case NONE: {
                return suffix;
            }
        }
        return new StringTextComponent(Long.toString(in));
    }

    @Override
    public void render(MatrixStack matrixStack, int x, int y) {
        ElementProgressRender.render(this.style, this.current, this.max, matrixStack, x, y, this.getWidth(), this.getHeight());
    }

    @Override
    public int getWidth() {
        if (this.style.isLifeBar()) {
            if (this.current * 4L >= (long)this.style.getWidth()) {
                return 100;
            }
            return (int)(this.current * 4L + 2L);
        }
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeLong(this.current);
        buf.writeLong(this.max);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.func_179256_a(this.style.getPrefixComp());
        buf.func_179256_a(this.style.getSuffixComp());
        buf.writeInt(this.style.getBorderColor());
        buf.writeInt(this.style.getFilledColor());
        buf.writeInt(this.style.getAlternatefilledColor());
        buf.writeInt(this.style.getBackgroundColor());
        buf.writeBoolean(this.style.isShowText());
        buf.writeByte(this.style.getNumberFormat().ordinal());
        buf.writeBoolean(this.style.isLifeBar());
        buf.writeBoolean(this.style.isArmorBar());
        buf.func_179249_a((Enum)this.style.getAlignment());
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_PROGRESS;
    }
}

