/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import java.util.HashSet;
import java.util.Set;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.varia.LogicFacing;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class AnalogTileEntity
extends GenericTileEntity {
    private final LogicSupport support = new LogicSupport();
    @GuiValue(name="mul_eq")
    private float mulEqual = 1.0f;
    @GuiValue(name="mul_less")
    private float mulLess = 1.0f;
    @GuiValue(name="mul_greater")
    private float mulGreater = 1.0f;
    @GuiValue(name="add_eq")
    private int addEqual = 0;
    @GuiValue(name="add_less")
    private int addLess = 0;
    @GuiValue(name="add_greater")
    private int addGreater = 0;
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Analog").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_ANALOG, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));
    private static Set<BlockPos> loopDetector = new HashSet<BlockPos>();

    public AnalogTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_ANALOG.get());
    }

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/analog")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(AnalogTileEntity::new));
    }

    public void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.mulEqual = info.func_74760_g("mulE");
        this.mulLess = info.func_74760_g("mulL");
        this.mulGreater = info.func_74760_g("mulG");
        this.addEqual = info.func_74762_e("addE");
        this.addLess = info.func_74762_e("addL");
        this.addGreater = info.func_74762_e("addG");
    }

    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74776_a("mulE", this.mulEqual);
        info.func_74776_a("mulL", this.mulLess);
        info.func_74776_a("mulG", this.mulGreater);
        info.func_74768_a("addE", this.addEqual);
        info.func_74768_a("addL", this.addLess);
        info.func_74768_a("addG", this.addGreater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkRedstone(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (loopDetector.add(pos)) {
            try {
                LogicFacing facing = LogicSupport.getFacing((BlockState)state);
                Direction downSide = facing.getSide();
                Direction inputSide = facing.getInputSide();
                Direction rightSide = LogicSlabBlock.rotateLeft((Direction)downSide, (Direction)inputSide);
                Direction leftSide = LogicSlabBlock.rotateRight((Direction)downSide, (Direction)inputSide);
                int inputStrength = this.support.getInputStrength(world, pos, inputSide);
                int inputLeft = this.support.getInputStrength(world, pos, leftSide);
                int inputRight = this.support.getInputStrength(world, pos, rightSide);
                int outputStrength = inputLeft == inputRight ? (int)((float)inputStrength * this.mulEqual + (float)this.addEqual) : (inputLeft < inputRight ? (int)((float)inputStrength * this.mulLess + (float)this.addLess) : (int)((float)inputStrength * this.mulGreater + (float)this.addGreater));
                if (outputStrength > 15) {
                    outputStrength = 15;
                } else if (outputStrength < 0) {
                    outputStrength = 0;
                }
                int oldPower = this.support.getPowerOutput();
                this.support.setRedstoneState((GenericTileEntity)this, outputStrength);
                if (oldPower != outputStrength) {
                    world.func_195593_d(pos, this.func_195044_w().func_177230_c());
                }
            }
            finally {
                loopDetector.remove(pos);
            }
        }
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }
}

