/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.NamedEnum;
import mcjty.lib.varia.Sync;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import mcjty.rftoolsutility.modules.logic.tools.SequencerMode;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class SequencerTileEntity
extends TickingTileEntity
implements TickOrderHandler.IOrderTicker {
    private final LogicSupport support = new LogicSupport();
    private long cycleBits = 0L;
    private int currentStep = -1;
    public static final Key<Integer> PARAM_BIT = new Key("bit", Type.INTEGER);
    public static final Key<Boolean> PARAM_CHOICE = new Key("choice", Type.BOOLEAN);
    private SequencerMode mode = SequencerMode.MODE_ONCE1;
    @GuiValue
    public static final Value<SequencerTileEntity, String> VALUE_MODE = Value.createEnum((String)"mode", (NamedEnum[])SequencerMode.values(), SequencerTileEntity::getMode, SequencerTileEntity::setMode);
    @GuiValue
    private boolean endstate = false;
    @GuiValue
    private int stepcount = 64;
    @GuiValue
    private int delay = 1;
    private boolean prevIn = false;
    private int timer = 0;
    @Cap(type=CapType.CONTAINER)
    private LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Sequencer").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_SEQUENCER, (GenericTileEntity)this)).integerListener(Sync.integer(() -> (int)this.cycleBits, v -> this.cycleBits |= (long)v.intValue() & 0xFFFFFFFFL)).integerListener(Sync.integer(() -> (int)(this.cycleBits >> 32), v -> this.cycleBits |= (long)v.intValue() << 32 & 0xFFFFFFFF00000000L)).setupSync((GenericTileEntity)this));
    @ServerCommand
    public static final Command<?> CMD_FLIPBITS = Command.create((String)"sequencer.flipBits", (te, player, params) -> te.flipCycleBits());
    @ServerCommand
    public static final Command<?> CMD_CLEARBITS = Command.create((String)"sequencer.clearBits", (te, player, params) -> te.clearCycleBits());
    @ServerCommand
    public static final Command<?> CMD_SETBIT = Command.create((String)"sequencer.setBit", (te, player, params) -> te.setCycleBit((Integer)params.get(PARAM_BIT), (Boolean)params.get(PARAM_CHOICE)));

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/sequencer")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(SequencerTileEntity::new));
    }

    public SequencerTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_SEQUENCER.get());
    }

    public void checkRedstone(World world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public SequencerMode getMode() {
        return this.mode;
    }

    public void setMode(SequencerMode mode) {
        this.mode = mode;
        switch (mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: 
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                this.currentStep = -1;
                break;
            }
            case MODE_LOOP1: 
            case MODE_LOOP2: 
            case MODE_STEP: {
                this.currentStep = 0;
            }
        }
        this.func_70296_d();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    public boolean getCycleBit(int bit) {
        return (this.cycleBits >> bit & 1L) == 1L;
    }

    public long getCycleBits() {
        return this.cycleBits;
    }

    public void setCycleBit(int bit, boolean flag) {
        this.cycleBits = flag ? (this.cycleBits |= 1L << bit) : (this.cycleBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL);
        this.func_70296_d();
    }

    public void flipCycleBits() {
        this.cycleBits ^= 0xFFFFFFFFFFFFFFFFL;
        this.func_70296_d();
    }

    public void clearCycleBits() {
        this.cycleBits = 0L;
        this.func_70296_d();
    }

    protected void tickServer() {
        TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_4;
    }

    public void tickOnServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.handlePulse();
        }
        this.func_70296_d();
        --this.timer;
        if (this.timer <= 0) {
            this.timer = this.delay;
            this.support.setRedstoneState((GenericTileEntity)this, this.checkOutput() ? 15 : 0);
            this.handleCycle(this.powerLevel > 0);
        } else if (this.timer > this.delay) {
            this.timer = this.delay;
        }
    }

    public boolean checkOutput() {
        return this.currentStep == -1 ? this.endstate : this.getCycleBit(this.currentStep);
    }

    private void handleCycle(boolean redstone) {
        switch (this.mode) {
            case MODE_ONCE1: 
            case MODE_ONCE2: {
                if (this.currentStep == -1) break;
                this.nextStepAndStop();
                break;
            }
            case MODE_LOOP1: {
                this.nextStep();
                break;
            }
            case MODE_LOOP2: {
                this.nextStep();
                break;
            }
            case MODE_LOOP3: {
                if (!redstone) break;
                this.nextStep();
                break;
            }
            case MODE_LOOP4: {
                if (redstone) {
                    this.nextStep();
                    break;
                }
                this.currentStep = -1;
                break;
            }
        }
    }

    private void handlePulse() {
        switch (this.mode) {
            case MODE_ONCE1: {
                if (this.currentStep != -1) break;
                this.currentStep = 0;
                break;
            }
            case MODE_ONCE2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP1: {
                break;
            }
            case MODE_LOOP2: {
                this.currentStep = 0;
                break;
            }
            case MODE_LOOP3: 
            case MODE_LOOP4: {
                break;
            }
            case MODE_STEP: {
                this.nextStep();
            }
        }
    }

    private void nextStep() {
        ++this.currentStep;
        if (this.currentStep >= this.stepcount) {
            this.currentStep = 0;
        }
    }

    private void nextStepAndStop() {
        ++this.currentStep;
        if (this.currentStep >= this.stepcount) {
            this.currentStep = -1;
        }
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.support.setPowerOutput(tagCompound.func_74767_n("rs") ? 15 : 0);
        this.currentStep = tagCompound.func_74762_e("step");
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.timer = tagCompound.func_74762_e("timer");
    }

    public void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        if (info.func_74764_b("bits")) {
            this.cycleBits = info.func_74763_f("bits");
        }
        int m = info.func_74762_e("mode");
        this.mode = SequencerMode.values()[m];
        this.delay = (short)info.func_74762_e("delay");
        if (this.delay == 0) {
            this.delay = 1;
        }
        this.stepcount = (short)info.func_74762_e("stepCount");
        if (this.stepcount == 0) {
            this.stepcount = 64;
        }
        this.endstate = info.func_74767_n("endState");
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74757_a("rs", this.support.getPowerOutput() > 0);
        tagCompound.func_74768_a("step", this.currentStep);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74768_a("timer", this.timer);
    }

    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74772_a("bits", this.cycleBits);
        info.func_74768_a("mode", this.mode.ordinal());
        info.func_74768_a("delay", this.delay);
        info.func_74768_a("stepCount", this.stepcount);
        info.func_74757_a("endState", this.endstate);
    }
}

