/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Locale;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClockClientScreenModule
implements IClientScreenModule<IModuleData> {
    private int color = 0xFFFFFF;
    private String line = "";
    private boolean large = false;

    public IClientScreenModule.TransformMode getTransformMode() {
        return this.large ? IClientScreenModule.TransformMode.TEXTLARGE : IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return this.large ? 20 : 10;
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, IModuleRenderHelper renderHelper, FontRenderer fontRenderer, int currenty, IModuleData screenData, ModuleRenderInfo renderInfo) {
        int y;
        int xoffset;
        Minecraft minecraft = Minecraft.func_71410_x();
        long time = minecraft.field_71441_e.func_82737_E();
        long hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        String timeString = String.format(Locale.ENGLISH, "%02d:%02d", hour, minute);
        if (this.large) {
            xoffset = 4;
            y = currenty / 2 + 1;
        } else {
            xoffset = 7;
            y = currenty;
        }
        renderHelper.renderText(matrixStack, buffer, xoffset, y, this.color, renderInfo, this.line + " " + timeString);
    }

    public void mouseClick(World world, int x, int y, boolean clicked) {
    }

    public void setupFromNBT(CompoundNBT tagCompound, RegistryKey<World> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.func_74779_i("text");
            this.color = tagCompound.func_74764_b("color") ? tagCompound.func_74762_e("color") : 0xFFFFFF;
            this.large = tagCompound.func_74767_n("large");
        }
    }

    public boolean needsServerData() {
        return false;
    }
}

