/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.entity.ai;

import com.performant.coremod.Performant;
import com.performant.coremod.entity.ai.CustomGoalSelector;
import com.performant.coremod.entity.ai.goals.CustomPriotizedSlowedGoal;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.TurtleEntity;

public class CustomGoalTypeData {
    private final HashMap<Class<? extends Goal>, CustomGoalTypeParameter> GOAL_TYPES = new HashMap();

    public CustomGoalTypeData() {
        this.GOAL_TYPES.put(TemptGoal.class, new CustomGoalTypeParameter(g -> g, 1, 1, (Boolean)Performant.getConfig().getCommon().optimizeTempt.get()));
        this.GOAL_TYPES.put(AvoidEntityGoal.class, new CustomGoalTypeParameter(g -> g, 4, 10, (Boolean)Performant.getConfig().getCommon().optimizeAvoid.get()));
        this.GOAL_TYPES.put(PanicGoal.class, new CustomGoalTypeParameter(g -> g, 3, 4, (Boolean)Performant.getConfig().getCommon().optimizePanic.get()));
        this.GOAL_TYPES.put(BreedGoal.class, new CustomGoalTypeParameter(g -> g, 10, 1, (Boolean)Performant.getConfig().getCommon().optimizeBreed.get()));
        this.GOAL_TYPES.put(FoxEntity.FindShelterGoal.class, new CustomGoalTypeParameter(g -> g, 20, 1, (Boolean)Performant.getConfig().getCommon().slowFindShelter.get()));
        this.GOAL_TYPES.put(TurtleEntity.GoHomeGoal.class, new CustomGoalTypeParameter(g -> g, 1, 100, true));
        this.GOAL_TYPES.put(TurtleEntity.TravelGoal.class, new CustomGoalTypeParameter(g -> g, 1, 100, true));
    }

    public PrioritizedGoal getPriotizedGoalFor(int priority, Goal goal, CustomGoalSelector selector) {
        CustomGoalTypeParameter params = this.GOAL_TYPES.get(goal.getClass());
        if (params != null && params.isEnabled) {
            return new CustomPriotizedSlowedGoal(priority, params.goalConverter.apply(goal), selector, params.shouldExecuteRate, params.tickRate);
        }
        return new PrioritizedGoal(priority, goal);
    }

    public class CustomGoalTypeParameter {
        public final Function<Goal, Goal> goalConverter;
        public final int shouldExecuteRate;
        public final int tickRate;
        public final boolean isEnabled;

        private CustomGoalTypeParameter(Function<Goal, Goal> goalConverter, int shouldExecuteRate, int tickRate, boolean isEnabled) {
            this.goalConverter = goalConverter;
            this.shouldExecuteRate = shouldExecuteRate;
            this.tickRate = tickRate;
            this.isEnabled = isEnabled;
        }
    }
}

