/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.event;

import com.electronwill.nightconfig.core.file.FileWatcher;
import com.mojang.brigadier.CommandDispatcher;
import com.performant.coremod.Performant;
import com.performant.coremod.commands.EntryPoint;
import com.performant.coremod.config.ConfigurationCache;
import com.performant.coremod.entity.ai.CustomGoalSelector;
import com.performant.coremod.entity.threading.ActionThread;
import com.performant.coremod.entity.threading.IThreadedMoveEntity;
import com.performant.coremod.entity.threading.MoveThread;
import com.performant.coremod.world.IServerChunkProviderThreadsUnloadChunk;
import com.performant.coremod.world.IntegratedServerHangWatchdog;
import java.io.IOException;
import net.minecraft.client.audio.ISound;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.MobEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DefaultWithNameUncaughtExceptionHandler;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class ForgeBusEventHandler {
    private static int serverTickTimer = 0;
    private static int meanTickCount = 0;
    private static double meanTickSum = 1.0;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAdded(@NotNull EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K) {
            String registryName = event.getEntity().func_200600_R().getRegistryName().toString();
            if (!registryName.isEmpty() && ConfigurationCache.forbiddenMobs.contains(registryName)) {
                event.setCanceled(true);
                event.getEntity().func_70106_y();
                return;
            }
            if (event.getEntity() instanceof MobEntity) {
                MobEntity mob = (MobEntity)event.getEntity();
                mob.field_70715_bh = new CustomGoalSelector(mob.field_70715_bh, mob);
                mob.field_70714_bg = new CustomGoalSelector(mob.field_70714_bg, mob);
            }
        }
        if (event.getEntity() instanceof IThreadedMoveEntity) {
            ((IThreadedMoveEntity)event.getEntity()).getCache().setInvalid();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (ConfigurationCache.adaptiveSpeed && event.phase == TickEvent.Phase.START) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            double lastTickMs = (double)server.field_71311_j[server.func_71259_af() % 100] * 1.0E-6;
            ConfigurationCache.slownessFactor = lastTickMs > 50.0 ? MathHelper.func_151237_a((double)(lastTickMs / 50.0), (double)1.0, (double)2.0) : 1.0;
        }
        ConfigurationCache.chunkDirtyCount = 0;
        if (++serverTickTimer == 20) {
            meanTickSum += (double)ForgeBusEventHandler.average(ServerLifecycleHooks.getCurrentServer().field_71311_j) * 1.0E-6;
            if (++meanTickCount >= 30) {
                ConfigurationCache.CURRENT_MEAN_TICK_TIME = meanTickSum / (double)meanTickCount;
                ConfigurationCache.TPS = 1000.0 / ConfigurationCache.CURRENT_MEAN_TICK_TIME;
                meanTickCount = 0;
                meanTickSum = 1.0;
            }
            serverTickTimer = 0;
        }
    }

    private static long average(long[] values) {
        if (values == null || values.length == 0) {
            return 0L;
        }
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        EntryPoint.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onServerStopped(FMLServerStoppedEvent event) {
        MoveThread.shutDown();
        ActionThread.shutDown();
    }

    @SubscribeEvent
    public static void onServerStarted(FMLServerStartedEvent event) {
        MoveThread.shutDown();
        ActionThread.shutDown();
        for (int i = 0; i < 4; ++i) {
            new MoveThread();
        }
        MoveThread.running = true;
        new ActionThread();
        ActionThread.running = true;
        if (((Boolean)Performant.getConfig().getCommon().disableConfigReload.get()).booleanValue()) {
            try {
                FileWatcher.defaultInstance().stop();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void serverStart(FMLServerStartingEvent event) {
        if (!event.getServer().func_71262_S() && (Integer)Performant.getConfig().getCommon().singlePlayerWatchDogTimeout.get() > 0) {
            Thread thread1 = new Thread(new IntegratedServerHangWatchdog(event.getServer()));
            thread1.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultWithNameUncaughtExceptionHandler(LogManager.getLogger()));
            thread1.setName("Integrated Server Watchdog");
            thread1.setDaemon(true);
            thread1.start();
            Performant.LOGGER.info("Integrated Server Watchdog started");
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        AbstractChunkProvider provider;
        if (!event.getWorld().func_201670_d() && (provider = event.getWorld().func_72863_F()) instanceof IServerChunkProviderThreadsUnloadChunk) {
            ((IServerChunkProviderThreadsUnloadChunk)provider).onChunkUnloadClean(event.getChunk().func_76632_l().func_201841_a());
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(FMLServerStoppingEvent event) {
        MoveThread.running = false;
        ActionThread.running = false;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onPlaySound(PlaySoundEvent event) {
        int similarcount = 0;
        if (event.getManager() == null || event.getManager().field_148624_n == null || event.getSound() == null) {
            return;
        }
        for (ISound sound : event.getManager().field_148624_n.keySet()) {
            if (!sound.func_147650_b().equals((Object)event.getSound().func_147650_b()) || ++similarcount != ConfigurationCache.maxSameSounds) continue;
            event.setResultSound(null);
            break;
        }
    }
}

