/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.connection;

import com.google.common.base.Charsets;
import com.performant.coremod.Performant;
import com.performant.coremod.config.ConfigurationCache;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.NettyCompressionDecoder;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NettyCompressionDecoder.class}, priority=98)
public abstract class NettyCompressionDecoderMixin
extends ByteToMessageDecoder {
    private boolean debugDecoding = false;

    @Inject(method={"decode"}, at={@At(value="INVOKE", target="io/netty/handler/codec/DecoderException.<init> (Ljava/lang/String;)V")}, cancellable=true, require=0)
    private void onTooLarge(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> p_decode_3_, CallbackInfo ci) {
        if (!ConfigurationCache.displayTooLargePackets) {
            return;
        }
        if (this.debugDecoding) {
            ci.cancel();
            return;
        }
        Performant.LOGGER.error("Received too large message, debug print below!");
        this.debugDecoding = true;
        ArrayList decodingResults = new ArrayList();
        this.callDecode(ctx, buffer.copy(), decodingResults);
        this.debugDecoding = false;
        Performant.LOGGER.error("----BEGIND PRINTING PACKET-----");
        for (int i = 0; i < decodingResults.size(); ++i) {
            Performant.LOGGER.error("Data:" + ((ByteBuf)decodingResults.get(i)).toString(Charsets.UTF_8));
        }
        Performant.LOGGER.error("----END PRINTING PACKET-----");
    }
}

