/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.entity;

import com.performant.coremod.Performant;
import com.performant.coremod.config.ConfigurationCache;
import com.performant.coremod.entity.INoRenderEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityFPSMixin
implements INoRenderEntity {
    boolean canSee = true;
    boolean isInFrustum = false;
    int fpsCounter = 0 - ConfigurationCache.rand.nextInt(500);
    int interval = ConfigurationCache.rand.nextInt(500);
    int unseenTicks = 0;
    final Entity self = (Entity)this;

    @Shadow
    public abstract EntityType<?> func_200600_R();

    @Inject(method={"shouldRender"}, at={@At(value="HEAD")}, cancellable=true)
    private void testRange(double x, double y, double z, CallbackInfoReturnable<Boolean> cir) {
        if (!this.isInFrustum || this.self instanceof PlayerEntity) {
            return;
        }
        if (!this.canSee) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public void setInFrustum(boolean inFrustum) {
        if (!this.isInFrustum && inFrustum) {
            this.interval = Minecraft.func_71410_x().field_71439_g.func_233580_cy_().func_218139_n((Vector3i)this.self.func_233580_cy_()) >> 2;
        }
        this.isInFrustum = inFrustum;
    }

    @Inject(method={"canUpdate()Z"}, at={@At(value="HEAD")}, remap=false)
    private void onTick(CallbackInfoReturnable<Boolean> cir) {
        this.onDistUpdate();
    }

    @Override
    public void onDistUpdate() {
        if (!this.isInFrustum || !this.self.field_70170_p.field_72995_K || Minecraft.func_71410_x().field_71439_g == null || this.self instanceof PlayerEntity) {
            return;
        }
        if (this.fpsCounter++ >= this.interval) {
            this.fpsCounter = 0;
            if (!Minecraft.func_71410_x().field_71439_g.func_70685_l(this.self)) {
                if (this.canSee) {
                    if (!((this.unseenTicks += this.interval) <= this.self.func_200600_R().field_233594_bl_ * 5 + 200 || this.self instanceof LivingEntity && !((Boolean)Performant.getConfig().getCommon().alwaysglow.get()).booleanValue() && ((LivingEntity)this.self).func_70644_a(Effects.field_188423_x) || ConfigurationCache.excludedRenderHidingMobs.contains(this.func_200600_R().getRegistryName()))) {
                        this.unseenTicks = 0;
                        this.canSee = false;
                    }
                } else {
                    this.unseenTicks = 0;
                }
            } else {
                this.unseenTicks = 0;
                this.canSee = true;
            }
            this.interval = this.getDistance(Minecraft.func_71410_x().field_71439_g.func_233580_cy_(), this.self.func_233580_cy_()) >> 1;
            if (this.interval < 15) {
                this.canSee = true;
            }
        }
    }

    private int getDistance(BlockPos a, BlockPos b) {
        return Math.abs(a.func_177958_n() - b.func_177958_n()) + 2 * Math.abs(a.func_177956_o() - b.func_177956_o()) + Math.abs(a.func_177952_p() - b.func_177952_p());
    }
}

