/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.entity;

import com.performant.coremod.config.ConfigurationCache;
import com.performant.coremod.entity.INoRenderEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityUpdateMixin {
    private int rangeUpdateCounter = 0;
    private int rangeUpdateInterval = 0;
    private int range = 0;
    private int updateCounter = 0;
    private int updateInterval = 0;
    private int timeTillEffect = 100;
    private final Entity self = (Entity)this;
    private int requiresUpdates = -1;
    private int trackingRange = 0;

    @Inject(method={"canUpdate()Z"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void checkIfUpdate(CallbackInfoReturnable<Boolean> cir) {
        if (this.self.field_70170_p.func_201670_d() || this.self instanceof INPC || this.self instanceof PlayerEntity || this.requiresUpdates == -1 || this.requiresUpdates == 1 || !(this.self instanceof LivingEntity)) {
            if (this.requiresUpdates == -1) {
                this.requiresUpdates = this.self instanceof EnderDragonEntity || ConfigurationCache.excludedTickDistanceMobs.contains(this.self.func_200600_R().getRegistryName()) ? 1 : 0;
                this.trackingRange = this.self.func_200600_R().func_233602_m_();
            }
            return;
        }
        if (this.updateCounter++ < this.updateInterval) {
            if (this.self instanceof INoRenderEntity) {
                ((INoRenderEntity)this.self).onDistUpdate();
            }
            ((LivingEntity)this.self).func_213332_m(((LivingEntity)this.self).func_70654_ax() + 3);
            cir.setReturnValue((Object)false);
        } else {
            this.updateCounter = 0;
        }
        if (this.rangeUpdateCounter++ >= this.rangeUpdateInterval) {
            this.rangeUpdateCounter = 0;
            int maxDist = Integer.MAX_VALUE;
            for (PlayerEntity playerentity : this.self.field_70170_p.func_217369_A()) {
                float zDiff;
                float yDiff;
                float xDiff = (float)Math.abs(this.self.func_226277_ct_() - playerentity.func_226277_ct_());
                int dist = (int)(xDiff + (yDiff = (float)Math.abs(this.self.func_226278_cu_() - playerentity.func_226278_cu_())) * 2.0f + (zDiff = (float)Math.abs(this.self.func_226281_cx_() - playerentity.func_226281_cx_())));
                if (dist >= maxDist) continue;
                maxDist = dist;
            }
            if (maxDist == Integer.MAX_VALUE) {
                this.range = 0;
                this.rangeUpdateInterval = 40;
                this.updateInterval = 0;
                return;
            }
            this.range = maxDist;
            this.updateInterval = Math.max(0, this.range - (Math.max(this.trackingRange, 6) - ConfigurationCache.entityUpdateDistanceReduction) * 16 >> 1);
            if (this.range > (this.trackingRange - ConfigurationCache.entityUpdateDistanceReduction + 6) * 16) {
                this.updateInterval = Integer.MAX_VALUE;
            }
            if (this.updateInterval > 0) {
                if (this.timeTillEffect > 0) {
                    this.updateInterval = 0;
                    this.timeTillEffect -= this.rangeUpdateInterval;
                }
            } else {
                this.timeTillEffect = 1000;
            }
            this.rangeUpdateInterval = Math.min(20, this.range >> 2);
        }
    }
}

