/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.world.chunk;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nullable;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.PlayerGenerationTracker;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ChunkManager.class})
public abstract class ChunkManagerMixin {
    @Shadow
    @Final
    private PlayerGenerationTracker field_219271_y;
    @Shadow
    @Final
    private ChunkManager.ProxyTicketManager field_219267_u;
    @Shadow
    @Final
    private ServerWorld field_219255_i;
    @Shadow
    @Final
    private Int2ObjectMap<ChunkManager.EntityTracker> field_219272_z;
    @Shadow
    @Final
    private TemplateManager field_219269_w;
    @Shadow
    @Final
    private PointOfInterestManager field_219260_n;
    @Shadow
    @Final
    private static Logger field_219250_d;
    @Shadow
    @Final
    private ThreadTaskExecutor<Runnable> field_219257_k;
    int counter = 0;
    private final ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("ChunkLoaderWorker-%d").setDaemon(true).build();
    private final ExecutorService executorService1 = Executors.newFixedThreadPool(1, this.namedThreadFactory);

    @Shadow
    public static double func_219217_a(ChunkPos chunkPosIn, Entity entityIn) {
        return 0.0;
    }

    @Shadow
    protected abstract void func_241089_g_(ChunkPos var1);

    @Shadow
    protected abstract byte func_241088_a_(ChunkPos var1, ChunkStatus.Type var2);

    @Shadow
    @Nullable
    protected abstract CompoundNBT func_219178_f(ChunkPos var1) throws IOException;

    @Overwrite
    public boolean func_219243_d(ChunkPos chunkPosIn) {
        long i = chunkPosIn.func_201841_a();
        if (!this.field_219267_u.func_223494_d(i)) {
            return true;
        }
        for (PlayerEntity player : this.field_219271_y.field_219449_a.keySet()) {
            if (player.func_175149_v() || !(ChunkManagerMixin.func_219217_a(chunkPosIn, (Entity)player) < 16384.0)) continue;
            return false;
        }
        return true;
    }

    @Overwrite
    public void func_219169_g() {
        ArrayList list = Lists.newArrayList();
        List list1 = this.field_219255_i.func_217369_A();
        if (++this.counter == 10) {
            this.counter = 0;
        }
        for (ChunkManager.EntityTracker chunkmanager$entitytracker : this.field_219272_z.values()) {
            SectionPos sectionpos1;
            SectionPos sectionpos;
            if (this.counter == 0 && !Objects.equals(sectionpos = chunkmanager$entitytracker.field_219405_e, sectionpos1 = SectionPos.func_218157_a((Entity)chunkmanager$entitytracker.field_219403_c))) {
                chunkmanager$entitytracker.func_219397_a(list1);
                Entity entity = chunkmanager$entitytracker.field_219403_c;
                if (entity instanceof ServerPlayerEntity) {
                    list.add((ServerPlayerEntity)entity);
                }
                chunkmanager$entitytracker.field_219405_e = sectionpos1;
            }
            if (chunkmanager$entitytracker.field_219406_f.isEmpty() && !(chunkmanager$entitytracker.field_219403_c instanceof PlayerEntity) && this.counter != 0) continue;
            chunkmanager$entitytracker.field_219402_b.func_219453_a();
        }
        if (!list.isEmpty()) {
            for (ChunkManager.EntityTracker chunkmanager$entitytracker1 : this.field_219272_z.values()) {
                chunkmanager$entitytracker1.func_219397_a((List)list);
            }
        }
    }

    @Overwrite
    public CompletableFuture<Either<IChunk, ChunkHolder.IChunkLoadingError>> func_223172_f(ChunkPos p_223172_1_) {
        CompletionStage chunkReadFuture = CompletableFuture.supplyAsync(() -> {
            try {
                CompoundNBT compoundnbt = this.func_219178_f(p_223172_1_);
                return compoundnbt;
            }
            catch (Exception reportedexception) {
                Throwable throwable = reportedexception.getCause();
                if (!(throwable instanceof IOException)) {
                    this.func_241089_g_(p_223172_1_);
                }
                field_219250_d.error("Couldn't load chunk {}", (Object)p_223172_1_, (Object)throwable);
                return null;
            }
        }, this.executorService1).thenApplyAsync(compoundnbt -> {
            try {
                this.field_219255_i.func_217381_Z().func_230035_c_("chunkLoad");
                if (compoundnbt != null) {
                    boolean flag;
                    boolean bl = flag = compoundnbt.func_150297_b("Level", 10) && compoundnbt.func_74775_l("Level").func_150297_b("Status", 8);
                    if (flag) {
                        ChunkPrimer ichunk = ChunkSerializer.func_222656_a((ServerWorld)this.field_219255_i, (TemplateManager)this.field_219269_w, (PointOfInterestManager)this.field_219260_n, (ChunkPos)p_223172_1_, (CompoundNBT)compoundnbt);
                        ichunk.func_177432_b(this.field_219255_i.func_82737_E());
                        this.func_241088_a_(p_223172_1_, ichunk.func_201589_g().func_202129_d());
                        return Either.left((Object)ichunk);
                    }
                    field_219250_d.error("Chunk file at {} is missing level data, skipping", (Object)p_223172_1_);
                }
            }
            catch (ReportedException reportedexception) {
                Throwable throwable = reportedexception.getCause();
                if (!(throwable instanceof IOException)) {
                    this.func_241089_g_(p_223172_1_);
                    throw reportedexception;
                }
                field_219250_d.error("Couldn't load chunk {}", (Object)p_223172_1_, (Object)throwable);
            }
            catch (Exception exception) {
                field_219250_d.error("Couldn't load chunk {}", (Object)p_223172_1_, (Object)exception);
            }
            this.func_241089_g_(p_223172_1_);
            return Either.left((Object)new ChunkPrimer(p_223172_1_, UpgradeData.field_196994_a));
        }, (Executor)this.field_219257_k);
        return chunkReadFuture;
    }
}

