/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.hooks.biome;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import me.shedaniel.architectury.hooks.biome.BiomeProperties;
import me.shedaniel.architectury.hooks.biome.ClimateProperties;
import me.shedaniel.architectury.hooks.biome.EffectsProperties;
import me.shedaniel.architectury.hooks.biome.GenerationProperties;
import me.shedaniel.architectury.hooks.biome.SpawnProperties;
import net.minecraft.client.audio.BackgroundMusicSelector;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.biome.MoodSoundAmbience;
import net.minecraft.world.biome.ParticleEffectAmbience;
import net.minecraft.world.biome.SoundAdditionsAmbience;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.carver.ConfiguredCarver;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.StructureFeature;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import org.jetbrains.annotations.Nullable;

public final class BiomeHooks {
    public static BiomeProperties getBiomeProperties(Biome biome) {
        return new BiomeWrapped(biome);
    }

    public static class BiomeWrapped
    implements BiomeProperties {
        protected final Biome biome;
        protected final ClimateProperties climateProperties;
        protected final EffectsProperties effectsProperties;
        protected final GenerationProperties generationProperties;
        protected final SpawnProperties spawnProperties;

        public BiomeWrapped(Biome biome) {
            this(biome, new ClimateWrapped(biome), new EffectsWrapped(biome), new GenerationSettingsWrapped(biome), new SpawnSettingsWrapped(biome));
        }

        public BiomeWrapped(Biome biome, ClimateProperties climateProperties, EffectsProperties effectsProperties, GenerationProperties generationProperties, SpawnProperties spawnProperties) {
            this.biome = biome;
            this.climateProperties = climateProperties;
            this.effectsProperties = effectsProperties;
            this.generationProperties = generationProperties;
            this.spawnProperties = spawnProperties;
        }

        @Override
        public ClimateProperties getClimateProperties() {
            return this.climateProperties;
        }

        @Override
        public EffectsProperties getEffectsProperties() {
            return this.effectsProperties;
        }

        @Override
        public GenerationProperties getGenerationProperties() {
            return this.generationProperties;
        }

        @Override
        public SpawnProperties getSpawnProperties() {
            return this.spawnProperties;
        }

        @Override
        public Biome.Category getCategory() {
            return this.biome.field_201877_au;
        }

        @Override
        public float getDepth() {
            return this.biome.field_76748_D;
        }

        @Override
        public float getScale() {
            return this.biome.field_76749_E;
        }
    }

    public static class SpawnSettingsWrapped
    implements SpawnProperties {
        protected final MobSpawnInfo settings;

        public SpawnSettingsWrapped(Biome biome) {
            this(biome.func_242433_b());
        }

        public SpawnSettingsWrapped(MobSpawnInfo settings) {
            this.settings = settings;
        }

        @Override
        public float getCreatureProbability() {
            return this.settings.func_242557_a();
        }

        @Override
        public Map<EntityClassification, List<MobSpawnInfo.Spawners>> getSpawners() {
            return null;
        }

        @Override
        public Map<EntityType<?>, MobSpawnInfo.SpawnCosts> getMobSpawnCosts() {
            return null;
        }

        @Override
        public boolean isPlayerSpawnFriendly() {
            return this.settings.func_242562_b();
        }
    }

    public static class GenerationSettingsWrapped
    implements GenerationProperties {
        protected final BiomeGenerationSettings settings;

        public GenerationSettingsWrapped(Biome biome) {
            this(biome.func_242440_e());
        }

        public GenerationSettingsWrapped(BiomeGenerationSettings settings) {
            this.settings = settings;
        }

        @Override
        public Optional<Supplier<ConfiguredSurfaceBuilder<?>>> getSurfaceBuilder() {
            return Optional.ofNullable(this.settings.func_242500_d());
        }

        @Override
        public List<Supplier<ConfiguredCarver<?>>> getCarvers(GenerationStage.Carving carving) {
            return this.settings.func_242489_a(carving);
        }

        @Override
        public List<Supplier<ConfiguredFeature<?, ?>>> getFeatures(GenerationStage.Decoration decoration) {
            return (List)this.settings.func_242498_c().get(decoration.ordinal());
        }

        @Override
        public List<List<Supplier<ConfiguredFeature<?, ?>>>> getFeatures() {
            return this.settings.func_242498_c();
        }

        @Override
        public List<Supplier<StructureFeature<?, ?>>> getStructureStarts() {
            return (List)this.settings.func_242487_a();
        }
    }

    public static class EffectsWrapped
    implements EffectsProperties.Mutable {
        protected final BiomeAmbience effects;

        public EffectsWrapped(Biome biome) {
            this(biome.func_235089_q_());
        }

        public EffectsWrapped(BiomeAmbience effects) {
            this.effects = effects;
        }

        @Override
        public EffectsProperties.Mutable setFogColor(int color) {
            this.effects.field_235205_b_ = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setWaterColor(int color) {
            this.effects.field_235206_c_ = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setWaterFogColor(int color) {
            this.effects.field_235207_d_ = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setSkyColor(int color) {
            this.effects.field_242523_e = color;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setFoliageColorOverride(@Nullable Integer colorOverride) {
            this.effects.field_242524_f = Optional.ofNullable(colorOverride);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setGrassColorOverride(@Nullable Integer colorOverride) {
            this.effects.field_242525_g = Optional.ofNullable(colorOverride);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setGrassColorModifier(BiomeAmbience.GrassColorModifier modifier) {
            this.effects.field_242526_h = modifier;
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientParticle(@Nullable ParticleEffectAmbience settings) {
            this.effects.field_235208_e_ = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientLoopSound(@Nullable SoundEvent sound) {
            this.effects.field_235209_f_ = Optional.ofNullable(sound);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientMoodSound(@Nullable MoodSoundAmbience settings) {
            this.effects.field_235210_g_ = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientAdditionsSound(@Nullable SoundAdditionsAmbience settings) {
            this.effects.field_235211_h_ = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setBackgroundMusic(@Nullable BackgroundMusicSelector music) {
            this.effects.field_235212_i_ = Optional.ofNullable(music);
            return this;
        }

        @Override
        public int getFogColor() {
            return this.effects.field_235205_b_;
        }

        @Override
        public int getWaterColor() {
            return this.effects.field_235206_c_;
        }

        @Override
        public int getWaterFogColor() {
            return this.effects.field_235207_d_;
        }

        @Override
        public int getSkyColor() {
            return this.effects.field_242523_e;
        }

        @Override
        public OptionalInt getFoliageColorOverride() {
            return this.effects.field_242524_f.map(OptionalInt::of).orElseGet(OptionalInt::empty);
        }

        @Override
        public OptionalInt getGrassColorOverride() {
            return this.effects.field_242525_g.map(OptionalInt::of).orElseGet(OptionalInt::empty);
        }

        @Override
        public BiomeAmbience.GrassColorModifier getGrassColorModifier() {
            return this.effects.field_242526_h;
        }

        @Override
        public Optional<ParticleEffectAmbience> getAmbientParticle() {
            return this.effects.field_235208_e_;
        }

        @Override
        public Optional<SoundEvent> getAmbientLoopSound() {
            return this.effects.field_235209_f_;
        }

        @Override
        public Optional<MoodSoundAmbience> getAmbientMoodSound() {
            return this.effects.field_235210_g_;
        }

        @Override
        public Optional<SoundAdditionsAmbience> getAmbientAdditionsSound() {
            return this.effects.field_235211_h_;
        }

        @Override
        public Optional<BackgroundMusicSelector> getBackgroundMusic() {
            return this.effects.field_235212_i_;
        }
    }

    public static class ClimateWrapped
    implements ClimateProperties.Mutable {
        protected final Biome.Climate climateSettings;

        public ClimateWrapped(Biome biome) {
            this(biome.field_242423_j);
        }

        public ClimateWrapped(Biome.Climate climateSettings) {
            this.climateSettings = climateSettings;
        }

        @Override
        public ClimateProperties.Mutable setPrecipitation(Biome.RainType precipitation) {
            this.climateSettings.field_242460_b = precipitation;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperature(float temperature) {
            this.climateSettings.field_242461_c = temperature;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperatureModifier(Biome.TemperatureModifier temperatureModifier) {
            this.climateSettings.field_242462_d = temperatureModifier;
            return this;
        }

        @Override
        public ClimateProperties.Mutable setDownfall(float downfall) {
            this.climateSettings.field_242463_e = downfall;
            return this;
        }

        @Override
        public Biome.RainType getPrecipitation() {
            return this.climateSettings.field_242460_b;
        }

        @Override
        public float getTemperature() {
            return this.climateSettings.field_242461_c;
        }

        @Override
        public Biome.TemperatureModifier getTemperatureModifier() {
            return this.climateSettings.field_242462_d;
        }

        @Override
        public float getDownfall() {
            return this.climateSettings.field_242463_e;
        }
    }

    public static class MutableBiomeWrapped
    extends BiomeWrapped
    implements BiomeProperties.Mutable {
        public MutableBiomeWrapped(Biome biome, GenerationProperties.Mutable generationProperties, SpawnProperties.Mutable spawnProperties) {
            this(biome, new ClimateWrapped(biome.field_242423_j), new EffectsWrapped(biome.func_235089_q_()), generationProperties, spawnProperties);
        }

        public MutableBiomeWrapped(Biome biome, ClimateProperties.Mutable climateProperties, EffectsProperties.Mutable effectsProperties, GenerationProperties.Mutable generationProperties, SpawnProperties.Mutable spawnProperties) {
            super(biome, climateProperties, effectsProperties, generationProperties, spawnProperties);
        }

        @Override
        public ClimateProperties.Mutable getClimateProperties() {
            return (ClimateProperties.Mutable)super.getClimateProperties();
        }

        @Override
        public EffectsProperties.Mutable getEffectsProperties() {
            return (EffectsProperties.Mutable)super.getEffectsProperties();
        }

        @Override
        public GenerationProperties.Mutable getGenerationProperties() {
            return (GenerationProperties.Mutable)super.getGenerationProperties();
        }

        @Override
        public SpawnProperties.Mutable getSpawnProperties() {
            return (SpawnProperties.Mutable)super.getSpawnProperties();
        }

        @Override
        public BiomeProperties.Mutable setCategory(Biome.Category category) {
            this.biome.field_201877_au = category;
            return this;
        }

        @Override
        public BiomeProperties.Mutable setDepth(float depth) {
            this.biome.field_76748_D = depth;
            return this;
        }

        @Override
        public BiomeProperties.Mutable setScale(float scale) {
            this.biome.field_76749_E = scale;
            return this;
        }
    }
}

