/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.mixin;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.Set;
import me.shedaniel.architectury.registry.trade.impl.OfferMixingContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={AbstractVillagerEntity.class})
public abstract class AbstractVillagerMixin
extends Entity {
    @Unique
    private final ThreadLocal<OfferMixingContext> offerContext = new ThreadLocal();

    public AbstractVillagerMixin(EntityType<?> entityType, World level) {
        super(entityType, level);
    }

    @Redirect(method={"addOffersFromItemListings(Lnet/minecraft/world/item/trading/MerchantOffers;[Lnet/minecraft/world/entity/npc/VillagerTrades$ItemListing;I)V"}, at=@At(value="INVOKE", target="Ljava/util/Set;iterator()Ljava/util/Iterator;"))
    public Iterator<Integer> overrideIterator(Set<Integer> set, MerchantOffers offers, VillagerTrades.ITrade[] itemListings, int maxOffers) {
        OfferMixingContext context = new OfferMixingContext((Integer)MoreObjects.firstNonNull((Object)this.architectury$getMaxOfferOverride(), (Object)maxOffers), itemListings, this.field_70146_Z);
        this.offerContext.set(context);
        return context.getIterator();
    }

    @ModifyVariable(method={"addOffersFromItemListings(Lnet/minecraft/world/item/trading/MerchantOffers;[Lnet/minecraft/world/entity/npc/VillagerTrades$ItemListing;I)V"}, at=@At(value="STORE"), ordinal=0)
    public MerchantOffer handleOffer(MerchantOffer offer) {
        OfferMixingContext context = this.offerContext.get();
        if (offer == null || context.getMaxOffers() == 0) {
            context.skipIteratorIfMaxOffersReached();
            return null;
        }
        MerchantOffer handledOffer = this.architectury$handleOffer(offer);
        if (handledOffer != null) {
            context.skipIteratorIfMaxOffersReached();
        }
        return handledOffer;
    }

    public MerchantOffer architectury$handleOffer(MerchantOffer offer) {
        return offer;
    }

    @Nullable
    public Integer architectury$getMaxOfferOverride() {
        return null;
    }
}

