/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.xnet.apiimpl.EnumStringTranslators;
import mcjty.xnet.apiimpl.items.ItemFilterCache;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class ItemConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    public static final String TAG_STACK = "stack";
    public static final String TAG_EXTRACT_AMOUNT = "extract_amount";
    public static final String TAG_SPEED = "speed";
    public static final String TAG_EXTRACT = "extract";
    public static final String TAG_TAGS = "od";
    public static final String TAG_NBT = "nbt";
    public static final String TAG_META = "meta";
    public static final String TAG_PRIORITY = "priority";
    public static final String TAG_COUNT = "count";
    public static final String TAG_FILTER = "flt";
    public static final String TAG_FILTER_IDX = "fltIdx";
    public static final String TAG_BLACKLIST = "blacklist";
    public static final int FILTER_SIZE = 18;
    private ItemMode itemMode = ItemMode.INS;
    private ExtractMode extractMode = ExtractMode.FIRST;
    private int speed = 2;
    private StackMode stackMode = StackMode.SINGLE;
    private boolean tagsMode = false;
    private boolean metaMode = false;
    private boolean nbtMode = false;
    private boolean blacklist = false;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer count = null;
    @Nullable
    private Integer extractAmount = null;
    private ItemStackList filters = ItemStackList.create((int)18);
    private int filterIndex = -1;
    private Predicate<ItemStack> matcher = null;
    private static final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "priority", "od", "meta", "nbt", "blacklist"});
    private static final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"count", "od", "meta", "nbt", "blacklist", "stack", "speed", "extract", "extract_amount"});

    public ItemMode getItemMode() {
        return this.itemMode;
    }

    public ItemConnectorSettings(@Nonnull Direction side) {
        super(side);
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.itemMode) {
            case INS: {
                return new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            }
            case EXT: {
                return new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
            }
        }
        return null;
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        String[] speeds = this.advanced ? new String[]{"5", "10", "20", "60", "100", "200"} : new String[]{"10", "20", "60", "100", "200"};
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_MODE, "Insert or extract mode", (Enum)this.itemMode, (Enum[])ItemMode.values()).shift(5).choices(TAG_STACK, "Single item, stack, or count", (Enum)this.stackMode, (Enum[])StackMode.values());
        if (this.stackMode == StackMode.COUNT && this.itemMode == ItemMode.EXT) {
            gui.integer(TAG_EXTRACT_AMOUNT, "Amount of items to extract|per operation", this.extractAmount, 30, Integer.valueOf(64));
        }
        gui.shift(10).choices(TAG_SPEED, "Number of ticks for each operation", Integer.toString(this.speed * 5), speeds).nl();
        gui.label("Pri").integer(TAG_PRIORITY, "Insertion priority", this.priority, 36).shift(5).label("#").integer(TAG_COUNT, this.itemMode == ItemMode.EXT ? "Amount in destination inventory|to keep" : "Max amount in destination|inventory", this.count, 30);
        if (this.itemMode == ItemMode.EXT) {
            gui.shift(5).choices(TAG_EXTRACT, "Extract mode (first available,|random slot or round robin)", (Enum)this.extractMode, (Enum[])ExtractMode.values());
        }
        gui.nl().toggleText(TAG_BLACKLIST, "Enable blacklist mode", "BL", this.blacklist).shift(0).toggleText(TAG_TAGS, "Tag matching", "Tags", this.tagsMode).shift(0).toggleText(TAG_META, "Metadata matching", "Meta", this.metaMode).shift(0).toggleText(TAG_NBT, "NBT matching", "NBT", this.nbtMode).shift(0).choices(TAG_FILTER_IDX, "Filter Index", this.getFilterIndexString(), new String[]{"<Off>", "1", "2", "3", "4"}).nl();
        for (int i = 0; i < 18; ++i) {
            gui.ghostSlot(TAG_FILTER + i, (ItemStack)this.filters.get(i));
        }
    }

    private String getFilterIndexString() {
        if (this.filterIndex == -1) {
            return "<Off>";
        }
        return Integer.toString(this.filterIndex);
    }

    public Predicate<ItemStack> getMatcher(IControllerContext context) {
        if (this.matcher == null) {
            ItemStackList filterList = ItemStackList.create();
            for (ItemStack stack2 : this.filters) {
                if (stack2.func_190926_b()) continue;
                filterList.add((Object)stack2);
            }
            Predicate<ItemStack> filterMatcher = this.getIndexFilterMatcher(context);
            if (filterList.isEmpty()) {
                this.matcher = filterMatcher != null ? filterMatcher : itemStack -> true;
            } else {
                ItemFilterCache filterCache = new ItemFilterCache(this.metaMode, this.tagsMode, this.blacklist, this.nbtMode, filterList);
                this.matcher = filterMatcher != null ? stack -> filterMatcher.test((ItemStack)stack) || filterCache.match((ItemStack)stack) : filterCache::match;
            }
        }
        return this.matcher;
    }

    @Nullable
    private Predicate<ItemStack> getIndexFilterMatcher(IControllerContext context) {
        if (this.filterIndex == -1) {
            return null;
        }
        return s -> context.getIndexedFilter(this.filterIndex - 1).test(s);
    }

    public StackMode getStackMode() {
        return this.stackMode;
    }

    public ExtractMode getExtractMode() {
        return this.extractMode;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nullable
    public Integer getCount() {
        return this.count;
    }

    public int getExtractAmount() {
        return this.extractAmount == null ? 1 : this.extractAmount;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public boolean isEnabled(String tag) {
        if (tag.startsWith(TAG_FILTER)) {
            return true;
        }
        if (tag.equals("facing")) {
            return this.advanced;
        }
        if (this.itemMode == ItemMode.INS) {
            return INSERT_TAGS.contains(tag);
        }
        return EXTRACT_TAGS.contains(tag);
    }

    public void update(Map<String, Object> data) {
        String idx;
        super.update(data);
        this.itemMode = ItemMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        Object emode = data.get(TAG_EXTRACT);
        this.extractMode = emode == null ? ExtractMode.FIRST : ExtractMode.valueOf(((String)emode).toUpperCase());
        this.stackMode = StackMode.valueOf(((String)data.get(TAG_STACK)).toUpperCase());
        this.speed = Integer.parseInt((String)data.get(TAG_SPEED)) / 5;
        if (this.speed == 0) {
            this.speed = 4;
        }
        this.filterIndex = "<Off>".equalsIgnoreCase(idx = (String)data.get(TAG_FILTER_IDX)) ? -1 : Integer.parseInt(idx);
        this.tagsMode = Boolean.TRUE.equals(data.get(TAG_TAGS));
        this.metaMode = Boolean.TRUE.equals(data.get(TAG_META));
        this.nbtMode = Boolean.TRUE.equals(data.get(TAG_NBT));
        this.blacklist = Boolean.TRUE.equals(data.get(TAG_BLACKLIST));
        this.priority = (Integer)data.get(TAG_PRIORITY);
        this.count = (Integer)data.get(TAG_COUNT);
        this.extractAmount = (Integer)data.get(TAG_EXTRACT_AMOUNT);
        for (int i = 0; i < 18; ++i) {
            this.filters.set(i, (Object)((ItemStack)data.get(TAG_FILTER + i)));
        }
        this.matcher = null;
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        ItemConnectorSettings.setEnumSafe((JsonObject)object, (String)"itemmode", (Enum)this.itemMode);
        ItemConnectorSettings.setEnumSafe((JsonObject)object, (String)"extractmode", (Enum)this.extractMode);
        ItemConnectorSettings.setEnumSafe((JsonObject)object, (String)"stackmode", (Enum)this.stackMode);
        object.add("tagsmode", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.tagsMode)));
        object.add("metamode", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.metaMode)));
        object.add("nbtmode", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.nbtMode)));
        object.add(TAG_BLACKLIST, (JsonElement)new JsonPrimitive(Boolean.valueOf(this.blacklist)));
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_PRIORITY, (Integer)this.priority);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"extractamount", (Integer)this.extractAmount);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_COUNT, (Integer)this.count);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_SPEED, (Integer)this.speed);
        ItemConnectorSettings.setIntegerSafe((JsonObject)object, (String)"filterindex", (Integer)this.filterIndex);
        for (int i = 0; i < 18; ++i) {
            if (((ItemStack)this.filters.get(i)).func_190926_b()) continue;
            object.add("filter" + i, (JsonElement)JSonTools.itemStackToJson((ItemStack)((ItemStack)this.filters.get(i))));
        }
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.itemMode = (ItemMode)ItemConnectorSettings.getEnumSafe((JsonObject)object, (String)"itemmode", EnumStringTranslators::getItemMode);
        this.extractMode = (ExtractMode)ItemConnectorSettings.getEnumSafe((JsonObject)object, (String)"extractmode", EnumStringTranslators::getExtractMode);
        this.stackMode = (StackMode)ItemConnectorSettings.getEnumSafe((JsonObject)object, (String)"stackmode", EnumStringTranslators::getStackMode);
        this.tagsMode = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"tagsmode");
        this.metaMode = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"metamode");
        this.nbtMode = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)"nbtmode");
        this.blacklist = ItemConnectorSettings.getBoolSafe((JsonObject)object, (String)TAG_BLACKLIST);
        this.priority = ItemConnectorSettings.getIntegerSafe((JsonObject)object, (String)TAG_PRIORITY);
        this.extractAmount = ItemConnectorSettings.getIntegerSafe((JsonObject)object, (String)"extractamount");
        this.count = ItemConnectorSettings.getIntegerSafe((JsonObject)object, (String)TAG_COUNT);
        this.speed = ItemConnectorSettings.getIntegerNotNull((JsonObject)object, (String)TAG_SPEED);
        this.filterIndex = object.has("filterindex") ? ItemConnectorSettings.getIntegerNotNull((JsonObject)object, (String)"filterindex") : -1;
        for (int i = 0; i < 18; ++i) {
            if (object.has("filter" + i)) {
                this.filters.set(i, (Object)JSonTools.jsonToItemStack((JsonObject)object.get("filter" + i).getAsJsonObject()));
                continue;
            }
            this.filters.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.itemMode = ItemMode.values()[tag.func_74771_c("itemMode")];
        this.extractMode = ExtractMode.values()[tag.func_74771_c("extractMode")];
        this.stackMode = StackMode.values()[tag.func_74771_c("stackMode")];
        if (tag.func_74764_b("spd")) {
            this.speed = tag.func_74762_e("spd");
        } else {
            this.speed = tag.func_74762_e(TAG_SPEED);
            if (this.speed == 0) {
                this.speed = 2;
            }
            this.speed *= 2;
        }
        this.filterIndex = tag.func_74764_b("filterindex") ? tag.func_74762_e("filterindex") : -1;
        this.tagsMode = tag.func_74767_n("tagsMode");
        this.metaMode = tag.func_74767_n("metaMode");
        this.nbtMode = tag.func_74767_n("nbtMode");
        this.blacklist = tag.func_74767_n(TAG_BLACKLIST);
        this.priority = tag.func_74764_b(TAG_PRIORITY) ? Integer.valueOf(tag.func_74762_e(TAG_PRIORITY)) : null;
        this.extractAmount = tag.func_74764_b("extractAmount") ? Integer.valueOf(tag.func_74762_e("extractAmount")) : null;
        this.count = tag.func_74764_b(TAG_COUNT) ? Integer.valueOf(tag.func_74762_e(TAG_COUNT)) : null;
        for (int i = 0; i < 18; ++i) {
            if (tag.func_74764_b("filter" + i)) {
                CompoundNBT itemTag = tag.func_74775_l("filter" + i);
                this.filters.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)itemTag));
                continue;
            }
            this.filters.set(i, (Object)ItemStack.field_190927_a);
        }
        this.matcher = null;
    }

    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("itemMode", (byte)this.itemMode.ordinal());
        tag.func_74774_a("extractMode", (byte)this.extractMode.ordinal());
        tag.func_74774_a("stackMode", (byte)this.stackMode.ordinal());
        tag.func_74768_a("spd", this.speed);
        tag.func_74768_a("filterindex", this.filterIndex);
        tag.func_74757_a("tagsMode", this.tagsMode);
        tag.func_74757_a("metaMode", this.metaMode);
        tag.func_74757_a("nbtMode", this.nbtMode);
        tag.func_74757_a(TAG_BLACKLIST, this.blacklist);
        if (this.priority != null) {
            tag.func_74768_a(TAG_PRIORITY, this.priority.intValue());
        }
        if (this.extractAmount != null) {
            tag.func_74768_a("extractAmount", this.extractAmount.intValue());
        }
        if (this.count != null) {
            tag.func_74768_a(TAG_COUNT, this.count.intValue());
        }
        for (int i = 0; i < 18; ++i) {
            if (((ItemStack)this.filters.get(i)).func_190926_b()) continue;
            CompoundNBT itemTag = new CompoundNBT();
            ((ItemStack)this.filters.get(i)).func_77955_b(itemTag);
            tag.func_218657_a("filter" + i, (INBT)itemTag);
        }
    }

    public static enum ItemMode {
        INS,
        EXT;

    }

    public static enum ExtractMode {
        FIRST,
        RND,
        ORDER;

    }

    public static enum StackMode {
        SINGLE,
        STACK,
        COUNT;

    }
}

