/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client;

import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.client.GunButtonBindings;
import com.mrcrayfish.guns.client.KeyBinds;
import com.mrcrayfish.guns.client.SpecialModels;
import com.mrcrayfish.guns.client.handler.AimingHandler;
import com.mrcrayfish.guns.client.handler.BulletTrailRenderingHandler;
import com.mrcrayfish.guns.client.handler.ControllerHandler;
import com.mrcrayfish.guns.client.handler.CrosshairHandler;
import com.mrcrayfish.guns.client.handler.GunRenderingHandler;
import com.mrcrayfish.guns.client.handler.RecoilHandler;
import com.mrcrayfish.guns.client.handler.ReloadHandler;
import com.mrcrayfish.guns.client.handler.ShootingHandler;
import com.mrcrayfish.guns.client.handler.SoundHandler;
import com.mrcrayfish.guns.client.render.entity.GrenadeRenderer;
import com.mrcrayfish.guns.client.render.entity.MissileRenderer;
import com.mrcrayfish.guns.client.render.entity.ProjectileRenderer;
import com.mrcrayfish.guns.client.render.entity.ThrowableGrenadeRenderer;
import com.mrcrayfish.guns.client.render.gun.ModelOverrides;
import com.mrcrayfish.guns.client.render.gun.model.BazookaModel;
import com.mrcrayfish.guns.client.render.gun.model.GrenadeLauncherModel;
import com.mrcrayfish.guns.client.render.gun.model.LongScopeModel;
import com.mrcrayfish.guns.client.render.gun.model.MediumScopeModel;
import com.mrcrayfish.guns.client.render.gun.model.MiniGunModel;
import com.mrcrayfish.guns.client.render.gun.model.ShortScopeModel;
import com.mrcrayfish.guns.client.screen.AttachmentScreen;
import com.mrcrayfish.guns.client.screen.WorkbenchScreen;
import com.mrcrayfish.guns.client.settings.GunOptions;
import com.mrcrayfish.guns.init.ModBlocks;
import com.mrcrayfish.guns.init.ModContainers;
import com.mrcrayfish.guns.init.ModEntities;
import com.mrcrayfish.guns.init.ModItems;
import com.mrcrayfish.guns.item.IColored;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.MessageAttachments;
import java.lang.reflect.Field;
import java.util.concurrent.CompletableFuture;
import net.minecraft.block.Block;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.MouseSettingsScreen;
import net.minecraft.client.gui.widget.list.OptionsRowList;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="cgm", value={Dist.CLIENT})
public class ClientHandler {
    private static Field mouseOptionsField;

    public static void setup() {
        MinecraftForge.EVENT_BUS.register((Object)AimingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)BulletTrailRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)CrosshairHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)GunRenderingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)RecoilHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ReloadHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)ShootingHandler.get());
        MinecraftForge.EVENT_BUS.register((Object)SoundHandler.get());
        if (GunMod.controllableLoaded) {
            MinecraftForge.EVENT_BUS.register((Object)new ControllerHandler());
            GunButtonBindings.register();
        }
        KeyBinds.register();
        ClientHandler.setupRenderLayers();
        ClientHandler.registerEntityRenders();
        ClientHandler.registerColors();
        ClientHandler.registerModelOverrides();
        ClientHandler.registerScreenFactories();
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_219534_a((stage, rm, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> CompletableFuture.runAsync(SpecialModels::clearCache).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0)));
        }
    }

    private static void setupRenderLayers() {
        RenderTypeLookup.setRenderLayer((Block)((Block)ModBlocks.WORKBENCH.get()), (RenderType)RenderType.func_228643_e_());
    }

    private static void registerEntityRenders() {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.PROJECTILE.get()), ProjectileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.GRENADE.get()), GrenadeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.MISSILE.get()), MissileRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.THROWABLE_GRENADE.get()), ThrowableGrenadeRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)ModEntities.THROWABLE_STUN_GRENADE.get()), ThrowableGrenadeRenderer::new);
    }

    private static void registerColors() {
        IItemColor color = (stack, index) -> {
            if (!((IColored)stack.func_77973_b()).canColor(stack)) {
                return -1;
            }
            if (index == 0 && stack.func_77942_o() && stack.func_77978_p().func_150297_b("Color", 3)) {
                return stack.func_77978_p().func_74762_e("Color");
            }
            return -1;
        };
        ForgeRegistries.ITEMS.forEach(item -> {
            if (item instanceof IColored) {
                Minecraft.func_71410_x().getItemColors().func_199877_a(color, new IItemProvider[]{item});
            }
        });
    }

    private static void registerModelOverrides() {
        ModelOverrides.register((Item)ModItems.MINI_GUN.get(), new MiniGunModel());
        ModelOverrides.register((Item)ModItems.SHORT_SCOPE.get(), new ShortScopeModel());
        ModelOverrides.register((Item)ModItems.MEDIUM_SCOPE.get(), new MediumScopeModel());
        ModelOverrides.register((Item)ModItems.LONG_SCOPE.get(), new LongScopeModel());
        ModelOverrides.register((Item)ModItems.BAZOOKA.get(), new BazookaModel());
        ModelOverrides.register((Item)ModItems.GRENADE_LAUNCHER.get(), new GrenadeLauncherModel());
    }

    private static void registerScreenFactories() {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.WORKBENCH.get()), WorkbenchScreen::new);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.ATTACHMENTS.get()), AttachmentScreen::new);
    }

    @SubscribeEvent
    public static void onScreenInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof MouseSettingsScreen) {
            MouseSettingsScreen screen = (MouseSettingsScreen)event.getGui();
            if (mouseOptionsField == null) {
                mouseOptionsField = ObfuscationReflectionHelper.findField(MouseSettingsScreen.class, (String)"field_213045_b");
                mouseOptionsField.setAccessible(true);
            }
            try {
                OptionsRowList list = (OptionsRowList)mouseOptionsField.get(screen);
                list.func_214334_a((AbstractOption)GunOptions.ADS_SENSITIVITY, GunOptions.CROSSHAIR);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71462_r == null && KeyBinds.KEY_ATTACHMENTS.func_151468_f()) {
            PacketHandler.getPlayChannel().sendToServer((Object)new MessageAttachments());
        }
    }
}

