/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cgm", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public enum SpecialModels {
    FLAME("flame"),
    MINI_GUN_BASE("mini_gun_base"),
    MINI_GUN_BARRELS("mini_gun_barrels"),
    GRENADE_LAUNCHER_BASE("grenade_launcher_base"),
    GRENADE_LAUNCHER_CYLINDER("grenade_launcher_cylinder");

    private ResourceLocation modelLocation;
    private boolean specialModel;
    @OnlyIn(value=Dist.CLIENT)
    private IBakedModel cachedModel;

    private SpecialModels(String modelName) {
        this(new ResourceLocation("cgm", "special/" + modelName), true);
    }

    private SpecialModels(ResourceLocation resource, boolean specialModel) {
        this.modelLocation = resource;
        this.specialModel = specialModel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IBakedModel getModel() {
        if (this.cachedModel == null) {
            IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(this.modelLocation);
            if (model == Minecraft.func_71410_x().func_209506_al().func_174951_a()) {
                return model;
            }
            this.cachedModel = model;
        }
        return this.cachedModel;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void register(ModelRegistryEvent event) {
        for (SpecialModels model : SpecialModels.values()) {
            if (!model.specialModel) continue;
            ModelLoader.addSpecialModel((ResourceLocation)model.modelLocation);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clearCache() {
        for (SpecialModels model : SpecialModels.values()) {
            if (!model.specialModel) continue;
            model.cachedModel = null;
        }
    }
}

