/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.guns.client.BulletTrail;
import com.mrcrayfish.guns.client.GunRenderType;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.util.OptifineHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BulletTrailRenderingHandler {
    private static BulletTrailRenderingHandler instance;
    private Map<Integer, BulletTrail> bullets = new HashMap<Integer, BulletTrail>();

    public static BulletTrailRenderingHandler get() {
        if (instance == null) {
            instance = new BulletTrailRenderingHandler();
        }
        return instance;
    }

    private BulletTrailRenderingHandler() {
    }

    public void add(BulletTrail trail) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            this.bullets.put(trail.getEntityId(), trail);
        }
    }

    public void remove(int entityId) {
        this.bullets.remove(entityId);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            if (event.phase == TickEvent.Phase.END) {
                this.bullets.values().forEach(BulletTrail::tick);
                this.bullets.values().removeIf(BulletTrail::isDead);
            }
        } else if (!this.bullets.isEmpty()) {
            this.bullets.clear();
        }
    }

    public void render(MatrixStack stack, float partialSticks) {
        for (BulletTrail bulletTrail : this.bullets.values()) {
            this.renderBulletTrail(bulletTrail, stack, partialSticks);
        }
    }

    @SubscribeEvent
    public void onRespawn(ClientPlayerNetworkEvent.RespawnEvent event) {
        this.bullets.clear();
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.bullets.clear();
    }

    private void renderBulletTrail(BulletTrail bulletTrail, MatrixStack matrixStack, float partialTicks) {
        if (OptifineHelper.isShadersEnabled()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        Entity entity = mc.func_175606_aa();
        if (entity == null || bulletTrail.isDead()) {
            return;
        }
        matrixStack.func_227860_a_();
        Vector3d view = mc.field_71460_t.func_215316_n().func_216785_c();
        Vector3d position = bulletTrail.getPosition();
        Vector3d motion = bulletTrail.getMotion();
        double bulletX = position.field_72450_a + motion.field_72450_a * (double)partialTicks;
        double bulletY = position.field_72448_b + motion.field_72448_b * (double)partialTicks;
        double bulletZ = position.field_72449_c + motion.field_72449_c * (double)partialTicks;
        matrixStack.func_227861_a_(bulletX - view.func_82615_a(), bulletY - view.func_82617_b(), bulletZ - view.func_82616_c());
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(bulletTrail.getYaw()));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-bulletTrail.getPitch() + 90.0f));
        Vector3d motionVec = new Vector3d(motion.field_72450_a, motion.field_72448_b, motion.field_72449_c);
        float trailLength = (float)(motionVec.func_72433_c() * bulletTrail.getTrailLengthMultiplier());
        float red = (float)(bulletTrail.getTrailColor() >> 16 & 0xFF) / 255.0f;
        float green = (float)(bulletTrail.getTrailColor() >> 8 & 0xFF) / 255.0f;
        float blue = (float)(bulletTrail.getTrailColor() & 0xFF) / 255.0f;
        float alpha = 0.3f;
        Entity shooter = bulletTrail.getShooter();
        if (shooter != null) {
            trailLength = (float)Math.min((double)trailLength, shooter.func_174824_e(partialTicks).func_72438_d(new Vector3d(bulletX, bulletY, bulletZ)));
        }
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        IRenderTypeBuffer.Impl renderTypeBuffer = mc.func_228019_au_().func_228487_b_();
        if (bulletTrail.isTrailVisible()) {
            RenderType bulletType = GunRenderType.getBulletTrail();
            IVertexBuilder builder = renderTypeBuffer.getBuffer(bulletType);
            builder.func_227888_a_(matrix4f, 0.0f, 0.0f, -0.035f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.035f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, -trailLength, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, -trailLength, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, -0.035f, 0.0f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.035f, 0.0f, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, -trailLength, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            builder.func_227888_a_(matrix4f, 0.0f, -trailLength, 0.0f).func_227885_a_(red, green, blue, alpha).func_227886_a_(0xF000F0).func_181675_d();
            Minecraft.func_71410_x().func_228019_au_().func_228487_b_().func_228462_a_(bulletType);
        }
        if (!bulletTrail.getItem().func_190926_b()) {
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)bulletTrail.getAge() + partialTicks) * 50.0f));
            matrixStack.func_227862_a_(0.275f, 0.275f, 0.275f);
            int combinedLight = WorldRenderer.func_228421_a_((IBlockDisplayReader)entity.field_70170_p, (BlockPos)new BlockPos(entity.func_213303_ch()));
            ItemStack stack = bulletTrail.getItem();
            RenderUtil.renderModel(stack, ItemCameraTransforms.TransformType.NONE, matrixStack, (IRenderTypeBuffer)renderTypeBuffer, combinedLight, OverlayTexture.field_229196_a_, null, null);
        }
        matrixStack.func_227865_b_();
    }
}

