/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.render.pose;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.guns.client.render.IHeldAnimation;
import com.mrcrayfish.guns.client.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class OneHandedPose
implements IHeldAnimation {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyPlayerModelRotation(PlayerEntity player, PlayerModel model, Hand hand, float aimProgress) {
        boolean right = Minecraft.func_71410_x().field_71474_y.field_186715_A == HandSide.RIGHT ? hand == Hand.MAIN_HAND : hand == Hand.OFF_HAND;
        ModelRenderer arm = right ? model.field_178723_h : model.field_178724_i;
        IHeldAnimation.copyModelAngles(model.field_78116_c, arm);
        arm.field_78795_f = (float)((double)arm.field_78795_f + Math.toRadians(-70.0));
    }

    @Override
    public void renderFirstPersonArms(PlayerEntity player, HandSide hand, ItemStack stack, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, float partialTicks) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, player.field_70170_p, (LivingEntity)player);
        float translateX = model.func_177552_f().field_188039_n.field_178365_c.func_195899_a();
        float translateZ = model.func_177552_f().field_188039_n.field_178365_c.func_195902_c();
        int side = hand.func_188468_a() == HandSide.RIGHT ? 1 : -1;
        matrixStack.func_227861_a_((double)(translateX * (float)side), 0.0, (double)(-translateZ));
        ClientPlayerEntity clientPlayer = (ClientPlayerEntity)player;
        boolean slim = clientPlayer.func_175154_l().equals("slim");
        float armWidth = slim ? 3.0f : 4.0f;
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        matrixStack.func_227861_a_(-0.25 * (double)side, 0.0, 0.0);
        matrixStack.func_227861_a_(-((double)armWidth / 2.0) * 0.0625 * (double)side, 0.0, 0.0);
        matrixStack.func_227861_a_(0.0, 0.15, -1.3125);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(75.0f));
        RenderUtil.renderFirstPersonArm(clientPlayer, hand, matrixStack, buffer, light);
    }

    @Override
    public boolean applyOffhandTransforms(PlayerEntity player, PlayerModel model, ItemStack stack, MatrixStack matrixStack, float partialTicks) {
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        if (player.func_213453_ef()) {
            matrixStack.func_227861_a_(-0.28125, -0.9375, -0.25);
        } else if (!player.func_184582_a(EquipmentSlotType.LEGS).func_190926_b()) {
            matrixStack.func_227861_a_(-0.25, -0.8125, 0.0625);
        } else {
            matrixStack.func_227861_a_(-0.21875, -0.8125, 0.0625);
        }
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(75.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(Math.toDegrees(model.field_178721_j.field_78795_f) / 10.0)));
        matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
        return true;
    }

    @Override
    public boolean canApplySprintingAnimation() {
        return false;
    }

    @Override
    public boolean canRenderOffhandItem() {
        return true;
    }

    @Override
    public double getFallSwayZOffset() {
        return 0.5;
    }
}

