/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.guns.init.ModParticleTypes;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;

public class BulletHoleData
implements IParticleData {
    public static final Codec<BulletHoleData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("dir").forGetter(data -> data.direction.ordinal()), (App)Codec.LONG.fieldOf("pos").forGetter(p_239806_0_ -> p_239806_0_.pos.func_218275_a())).apply((Applicative)builder, BulletHoleData::new));
    public static final IParticleData.IDeserializer<BulletHoleData> DESERIALIZER = new IParticleData.IDeserializer<BulletHoleData>(){

        public BulletHoleData fromCommand(ParticleType<BulletHoleData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int dir = reader.readInt();
            reader.expect(' ');
            long pos = reader.readLong();
            return new BulletHoleData(dir, pos);
        }

        public BulletHoleData fromNetwork(ParticleType<BulletHoleData> particleType, PacketBuffer buffer) {
            return new BulletHoleData(buffer.readInt(), buffer.readLong());
        }
    };
    private final Direction direction;
    private final BlockPos pos;

    public BulletHoleData(int dir, long pos) {
        this.direction = Direction.values()[dir];
        this.pos = BlockPos.func_218283_e((long)pos);
    }

    public BulletHoleData(Direction dir, BlockPos pos) {
        this.direction = dir;
        this.pos = pos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ParticleType<?> func_197554_b() {
        return (ParticleType)ModParticleTypes.BULLET_HOLE.get();
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.func_179249_a((Enum)this.direction);
        buffer.func_179255_a(this.pos);
    }

    public String func_197555_a() {
        return ForgeRegistries.PARTICLE_TYPES.getKey(this.func_197554_b()) + " " + this.direction.func_176742_j();
    }

    public static Codec<BulletHoleData> codec(ParticleType<BulletHoleData> type) {
        return CODEC;
    }
}

