/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseBlock;
import com.mrh0.buildersaddition.tileentity.CupboardTileEntity;
import com.mrh0.buildersaddition.util.IComparetorOverride;
import com.mrh0.buildersaddition.util.Util;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class Cupboard
extends BaseBlock
implements IWaterLoggable,
ITileEntityProvider {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final BooleanProperty MIRROR = BooleanProperty.func_177716_a((String)"mirror");
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static VoxelShape SHAPE_NORTH_LOWER = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_EAST_LOWER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_LOWER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)15.0);
    private static VoxelShape SHAPE_WEST_LOWER = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_NORTH_UPPER = Block.func_208617_a((double)0.0, (double)-16.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_EAST_UPPER = Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_UPPER = Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static VoxelShape SHAPE_WEST_UPPER = Block.func_208617_a((double)1.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Cupboard(String name, Block source) {
        super("cupboard_" + name, AbstractBlock.Properties.func_200950_a((AbstractBlock)source));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            World world = context.func_195991_k();
            boolean flag = world.func_175640_z(blockpos) || world.func_175640_z(blockpos.func_177984_a());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)MIRROR, (Comparable)Boolean.valueOf(context.func_225518_g_()))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(worldIn.func_204610_c(pos.func_177984_a()).func_206886_c() == Fluids.field_204546_a)), 3);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? true : blockstate.func_203425_a((Block)this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED, HALF, MIRROR});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    private VoxelShape getShapeForDirection(Direction d, boolean b) {
        switch (d) {
            case NORTH: {
                return b ? SHAPE_NORTH_UPPER : SHAPE_NORTH_LOWER;
            }
            case SOUTH: {
                return b ? SHAPE_SOUTH_UPPER : SHAPE_SOUTH_LOWER;
            }
            case EAST: {
                return b ? SHAPE_EAST_UPPER : SHAPE_EAST_LOWER;
            }
            case WEST: {
                return b ? SHAPE_WEST_UPPER : SHAPE_WEST_LOWER;
            }
        }
        return SHAPE_NORTH_LOWER;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeForDirection((Direction)state.func_177229_b((Property)FACING), state.func_177229_b(HALF) == DoubleBlockHalf.UPPER);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            if (!Util.accessCheck(worldIn, pos, (Direction)state.func_177229_b((Property)FACING)) || !Util.accessCheck(worldIn, pos.func_177984_a(), (Direction)state.func_177229_b((Property)FACING))) {
                return ActionResultType.CONSUME;
            }
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CupboardTileEntity) {
                player.func_213829_a((INamedContainerProvider)((CupboardTileEntity)tileentity));
                PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            }
        } else {
            if (!Util.accessCheck(worldIn, pos, (Direction)state.func_177229_b((Property)FACING)) || !Util.accessCheck(worldIn, pos.func_177977_b(), (Direction)state.func_177229_b((Property)FACING))) {
                return ActionResultType.CONSUME;
            }
            TileEntity tileentity = worldIn.func_175625_s(pos.func_177977_b());
            if (tileentity instanceof CupboardTileEntity) {
                player.func_213829_a((INamedContainerProvider)((CupboardTileEntity)tileentity));
                PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            }
        }
        return ActionResultType.CONSUME;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            CupboardTileEntity tileentity = this.getTE(state, worldIn, pos);
            if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
                BlockState upper = worldIn.func_180495_p(pos.func_177984_a());
                if (upper.func_177230_c() == this) {
                    worldIn.func_180501_a(pos.func_177984_a(), this.func_204507_t(upper).func_206886_c() == Fluids.field_204546_a ? this.func_204507_t(upper).func_206883_i() : Blocks.field_150350_a.func_176223_P(), 35);
                }
                if (tileentity != null) {
                    InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tileentity);
                    worldIn.func_175666_e(pos, (Block)this);
                    worldIn.func_175666_e(pos.func_177984_a(), (Block)this);
                }
            } else {
                BlockState lower = worldIn.func_180495_p(pos.func_177977_b());
                if (lower.func_177230_c() == this) {
                    worldIn.func_180501_a(pos.func_177977_b(), this.func_204507_t(lower).func_206886_c() == Fluids.field_204546_a ? this.func_204507_t(lower).func_206883_i() : Blocks.field_150350_a.func_176223_P(), 35);
                }
                if (tileentity != null) {
                    InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos.func_177977_b(), (IInventory)tileentity);
                    worldIn.func_175666_e(pos, (Block)this);
                    worldIn.func_175666_e(pos.func_177977_b(), (Block)this);
                }
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            return;
        }
        CupboardTileEntity tileentity = this.getTE(state, (World)worldIn, pos);
        if (tileentity != null) {
            tileentity.invTick();
        }
    }

    private CupboardTileEntity getTE(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileentity = state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? worldIn.func_175625_s(pos) : worldIn.func_175625_s(pos.func_177977_b());
        if (tileentity != null && tileentity instanceof CupboardTileEntity) {
            return (CupboardTileEntity)tileentity;
        }
        return null;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity instanceof INamedContainerProvider ? (INamedContainerProvider)tileentity : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new CupboardTileEntity();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        if (blockState.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return IComparetorOverride.getComparetorOverride(worldIn, pos);
        }
        return IComparetorOverride.getComparetorOverride(worldIn, pos.func_177977_b());
    }
}

