/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class IronLadder
extends BaseDerivativeBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", p -> p.func_176745_a() > 1 && p.func_176745_a() < Direction.values().length);
    protected static final VoxelShape NORTH_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)2.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)2.0);
    protected static final VoxelShape WEST_SHAPE = Block.func_208617_a((double)14.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)15.0);

    public IronLadder(String name) {
        super(name, Blocks.field_150339_S);
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        if (c.func_196000_l().func_176740_k() == Direction.Axis.Y) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)c.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(c.func_195991_k().func_204610_c(c.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)c.func_196000_l())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(c.func_195991_k().func_204610_c(c.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    private VoxelShape getShapeForDirection(Direction d) {
        switch (d) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeForDirection((Direction)state.func_177229_b((Property)FACING));
    }
}

