/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.proxy;

import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import net.minecraft.block.Block;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import vazkii.botania.client.core.handler.AstrolabePreviewHandler;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.handler.BoundTileRenderer;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.handler.ColorHandler;
import vazkii.botania.client.core.handler.ContributorFancinessHandler;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.client.core.handler.DebugHandler;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.handler.KonamiHandler;
import vazkii.botania.client.core.handler.LayerTerraHelmet;
import vazkii.botania.client.core.handler.LightningHandler;
import vazkii.botania.client.core.handler.ManaTabletRenderHandler;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.core.handler.ModelHandler;
import vazkii.botania.client.core.handler.PersistentVariableHelper;
import vazkii.botania.client.core.handler.RenderLexicon;
import vazkii.botania.client.core.handler.TooltipAdditionDisplayHandler;
import vazkii.botania.client.core.handler.TooltipHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.fx.FXLightning;
import vazkii.botania.client.fx.ModParticles;
import vazkii.botania.client.render.entity.RenderBabylonWeapon;
import vazkii.botania.client.render.entity.RenderCorporeaSpark;
import vazkii.botania.client.render.entity.RenderDoppleganger;
import vazkii.botania.client.render.entity.RenderMagicLandmine;
import vazkii.botania.client.render.entity.RenderManaStorm;
import vazkii.botania.client.render.entity.RenderNoop;
import vazkii.botania.client.render.entity.RenderPinkWither;
import vazkii.botania.client.render.entity.RenderPixie;
import vazkii.botania.client.render.entity.RenderPoolMinecart;
import vazkii.botania.client.render.entity.RenderSpark;
import vazkii.botania.client.render.tile.RenderTilePylon;
import vazkii.botania.client.render.tile.TEISR;
import vazkii.botania.common.block.BlockPylon;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockFloatingFlower;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.core.proxy.IProxy;
import vazkii.botania.common.entity.EntityDoppleganger;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ItemBottledMana;
import vazkii.botania.common.item.ItemSextant;
import vazkii.botania.common.item.ItemSpawnerMover;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.brew.ItemBrewBase;
import vazkii.botania.common.item.equipment.bauble.ItemDodgeRing;
import vazkii.botania.common.item.equipment.bauble.ItemMagnetRing;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;
import vazkii.botania.common.item.equipment.tool.bow.ItemLivingwoodBow;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraAxe;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.relic.ItemInfiniteFruit;
import vazkii.botania.common.item.rod.ItemTornadoRod;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.AccessorRenderTypeBuffers;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.PatchouliAPI;

public class ClientProxy
implements IProxy {
    public static boolean jingleTheBells = false;
    public static boolean dootDoot = false;
    public static KeyBinding CORPOREA_REQUEST;

    @Override
    public void registerHandlers() {
        ShaderHelper.initShaders();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::loadComplete);
        modBus.addListener(MiscellaneousIcons.INSTANCE::onModelRegister);
        modBus.addListener(MiscellaneousIcons.INSTANCE::onModelBake);
        modBus.addListener(ModelHandler::registerModels);
        modBus.addListener(ModParticles.FactoryHandler::registerFactories);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.HIGHEST, TooltipHandler::onTooltipEvent);
        forgeBus.addListener(TooltipAdditionDisplayHandler::onToolTipRender);
        forgeBus.addListener(RenderLexicon::renderHand);
        forgeBus.addListener(LightningHandler::onRenderWorldLast);
        forgeBus.addListener(KonamiHandler::clientTick);
        forgeBus.addListener(KonamiHandler::handleInput);
        forgeBus.addListener(KonamiHandler::renderBook);
        forgeBus.addListener(HUDHandler::onDrawScreenPost);
        forgeBus.addListener(DebugHandler::onDrawDebugText);
        forgeBus.addListener(CorporeaInputHandler::buttonPressed);
        forgeBus.addListener(ClientTickHandler::clientTickEnd);
        forgeBus.addListener(ClientTickHandler::renderTick);
        forgeBus.addListener(BoundTileRenderer::onWorldRenderLast);
        forgeBus.addListener(BossBarHandler::onBarRender);
        forgeBus.addListener(RenderMagicLandmine::onWorldRenderLast);
        forgeBus.addListener(AstrolabePreviewHandler::onWorldRenderLast);
        forgeBus.addListener(ItemDodgeRing::onKeyDown);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        boolean contestOngoing = ZonedDateTime.now().isBefore(ZonedDateTime.of(LocalDateTime.of(2021, Month.JULY, 11, 23, 0), ZoneOffset.UTC));
        PatchouliAPI.get().setConfigFlag("botania:contest_2021_ongoing", contestOngoing);
        PersistentVariableHelper.init();
        PersistentVariableHelper.save();
        if (((Boolean)ConfigHandler.CLIENT.enableSeasonalFeatures.get()).booleanValue()) {
            LocalDateTime now = LocalDateTime.now();
            if (now.getMonth() == Month.DECEMBER && now.getDayOfMonth() >= 16 || now.getMonth() == Month.JANUARY && now.getDayOfMonth() <= 2) {
                jingleTheBells = true;
            }
            if (now.getMonth() == Month.OCTOBER) {
                dootDoot = true;
            }
        }
        ClientProxy.registerRenderTypes();
        ClientProxy.registerEntityRenderers();
        CORPOREA_REQUEST = new KeyBinding("key.botania_corporea_request", (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.func_197954_a((int)67, (int)0), "Botania");
        ClientRegistry.registerKeyBinding((KeyBinding)CORPOREA_REQUEST);
        event.enqueueWork(ClientProxy::registerPropertyGetters);
    }

    private static void registerPropertyGetter(IItemProvider item, ResourceLocation id, IItemPropertyGetter propGetter) {
        ItemModelsProperties.func_239418_a_((Item)item.func_199767_j(), (ResourceLocation)id, (IItemPropertyGetter)propGetter);
    }

    private static void registerPropertyGetters() {
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.blackHoleTalisman, ResourceLocationHelper.prefix("active"), (stack, world, entity) -> ItemNBTHelper.getBoolean(stack, "active", false) ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.manaBottle, ResourceLocationHelper.prefix("swigs_taken"), (stack, world, entity) -> 6 - ItemBottledMana.getSwigsLeft(stack));
        ResourceLocation vuvuzelaId = ResourceLocationHelper.prefix("vuvuzela");
        IItemPropertyGetter isVuvuzela = (stack, world, entity) -> stack.func_200301_q().getString().toLowerCase(Locale.ROOT).contains("vuvuzela") ? 1.0f : 0.0f;
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.grassHorn, vuvuzelaId, isVuvuzela);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.leavesHorn, vuvuzelaId, isVuvuzela);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.snowHorn, vuvuzelaId, isVuvuzela);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.lexicon, ResourceLocationHelper.prefix("elven"), (stack, world, living) -> ModItems.lexicon.isElvenItem(stack) ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.manaCookie, ResourceLocationHelper.prefix("totalbiscuit"), (stack, world, entity) -> stack.func_200301_q().getString().toLowerCase(Locale.ROOT).contains("totalbiscuit") ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.slimeBottle, ResourceLocationHelper.prefix("active"), (stack, world, entity) -> stack.func_77942_o() && stack.func_77978_p().func_74767_n("active") ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.spawnerMover, ResourceLocationHelper.prefix("full"), (stack, world, entity) -> ItemSpawnerMover.hasData(stack) ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.temperanceStone, ResourceLocationHelper.prefix("active"), (stack, world, entity) -> ItemNBTHelper.getBoolean(stack, "active", false) ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.twigWand, ResourceLocationHelper.prefix("bindmode"), (stack, world, entity) -> ItemTwigWand.getBindMode(stack) ? 1.0f : 0.0f);
        ResourceLocation poolFullId = ResourceLocationHelper.prefix("full");
        IItemPropertyGetter poolFull = (stack, world, entity) -> {
            Block block = ((BlockItem)stack.func_77973_b()).func_179223_d();
            boolean renderFull = ((BlockPool)block).variant == BlockPool.Variant.CREATIVE || stack.func_77942_o() && stack.func_77978_p().func_74767_n("RenderFull");
            return renderFull ? 1.0f : 0.0f;
        };
        ClientProxy.registerPropertyGetter((IItemProvider)ModBlocks.manaPool, poolFullId, poolFull);
        ClientProxy.registerPropertyGetter((IItemProvider)ModBlocks.dilutedPool, poolFullId, poolFull);
        ClientProxy.registerPropertyGetter((IItemProvider)ModBlocks.creativePool, poolFullId, poolFull);
        ClientProxy.registerPropertyGetter((IItemProvider)ModBlocks.fabulousPool, poolFullId, poolFull);
        IItemPropertyGetter brewGetter = (stack, world, entity) -> {
            ItemBrewBase item = (ItemBrewBase)stack.func_77973_b();
            return item.getSwigs() - item.getSwigsLeft(stack);
        };
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.brewVial, ResourceLocationHelper.prefix("swigs_taken"), brewGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.brewFlask, ResourceLocationHelper.prefix("swigs_taken"), brewGetter);
        ResourceLocation holidayId = ResourceLocationHelper.prefix("holiday");
        IItemPropertyGetter holidayGetter = (stack, worldIn, entityIn) -> jingleTheBells ? 1.0f : 0.0f;
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.manaweaveHelm, holidayId, holidayGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.manaweaveChest, holidayId, holidayGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.manaweaveBoots, holidayId, holidayGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.manaweaveLegs, holidayId, holidayGetter);
        IItemPropertyGetter ringOnGetter = (stack, worldIn, entityIn) -> ItemMagnetRing.getCooldown(stack) <= 0 ? 1.0f : 0.0f;
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.magnetRing, ResourceLocationHelper.prefix("active"), ringOnGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.magnetRingGreater, ResourceLocationHelper.prefix("active"), ringOnGetter);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.elementiumShears, ResourceLocationHelper.prefix("reddit"), (stack, world, entity) -> stack.func_200301_q().getString().equalsIgnoreCase("dammit reddit") ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.manasteelSword, ResourceLocationHelper.prefix("elucidator"), (stack, world, entity) -> "the elucidator".equals(stack.func_200301_q().getString().toLowerCase(Locale.ROOT).trim()) ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.terraAxe, ResourceLocationHelper.prefix("active"), (stack, world, entity) -> entity instanceof PlayerEntity && !ItemTerraAxe.shouldBreak((PlayerEntity)entity) ? 0.0f : 1.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.terraPick, ResourceLocationHelper.prefix("tipped"), (stack, world, entity) -> ItemTerraPick.isTipped(stack) ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.terraPick, ResourceLocationHelper.prefix("active"), (stack, world, entity) -> ItemTerraPick.isEnabled(stack) ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.infiniteFruit, ResourceLocationHelper.prefix("boot"), (stack, worldIn, entity) -> ItemInfiniteFruit.isBoot(stack) ? 1.0f : 0.0f);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.tornadoRod, ResourceLocationHelper.prefix("active"), (stack, world, living) -> ItemTornadoRod.isFlying(stack) ? 1.0f : 0.0f);
        IItemPropertyGetter pulling = ItemModelsProperties.func_239417_a_((Item)Items.field_151031_f, (ResourceLocation)new ResourceLocation("pulling"));
        IItemPropertyGetter pull = (stack, worldIn, entity) -> {
            if (entity == null) {
                return 0.0f;
            }
            ItemLivingwoodBow item = (ItemLivingwoodBow)stack.func_77973_b();
            return entity.func_184607_cu() != stack ? 0.0f : (float)(stack.func_77988_m() - entity.func_184605_cv()) * item.chargeVelocityMultiplier() / 20.0f;
        };
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.livingwoodBow, new ResourceLocation("pulling"), pulling);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.livingwoodBow, new ResourceLocation("pull"), pull);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.crystalBow, new ResourceLocation("pulling"), pulling);
        ClientProxy.registerPropertyGetter((IItemProvider)ModItems.crystalBow, new ResourceLocation("pull"), pull);
    }

    private static void registerRenderTypes() {
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.defaultAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.forestAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.plainsAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.mountainAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.fungalAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.swampAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.desertAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.taigaAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.mesaAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.mossyAltar, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.ghostRail, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.solidVines, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.corporeaCrystalCube, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.manaGlass, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModFluffBlocks.managlassPane, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.elfGlass, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModFluffBlocks.alfglassPane, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.bifrost, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModFluffBlocks.bifrostPane, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.bifrostPerm, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.prism, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.starfield, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.abstrusePlatform, t -> true);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.infrangiblePlatform, t -> true);
        RenderTypeLookup.setRenderLayer((Block)ModBlocks.spectralPlatform, t -> true);
        Registry.field_212618_g.func_201756_e().filter(b -> Registry.field_212618_g.func_177774_c(b).func_110624_b().equals("botania")).forEach(b -> {
            if (b instanceof BlockFloatingFlower || b instanceof FlowerBlock || b instanceof TallFlowerBlock || b instanceof BlockModMushroom) {
                RenderTypeLookup.setRenderLayer((Block)b, (RenderType)RenderType.func_228643_e_());
            }
        });
    }

    private static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.MANA_BURST, RenderNoop::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.PLAYER_MOVER, RenderNoop::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.FLAME_RING, RenderNoop::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.MAGIC_LANDMINE, RenderMagicLandmine::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.MAGIC_MISSILE, RenderNoop::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.FALLING_STAR, RenderNoop::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.THROWN_ITEM, m -> new ItemRenderer(m, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.PIXIE, RenderPixie::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.DOPPLEGANGER, RenderDoppleganger::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.SPARK, RenderSpark::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.CORPOREA_SPARK, RenderCorporeaSpark::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.POOL_MINECART, RenderPoolMinecart::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.PINK_WITHER, RenderPinkWither::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.MANA_STORM, RenderManaStorm::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.BABYLON_WEAPON, RenderBabylonWeapon::new);
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.THORN_CHAKRAM, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.VINE_BALL, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(ModEntities.ENDER_AIR_BOTTLE, renderManager -> new SpriteRenderer(renderManager, Minecraft.func_71410_x().func_175599_af()));
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        event.enqueueWork(() -> {
            this.initAuxiliaryRender();
            ColorHandler.init();
            SortedMap<RenderType, BufferBuilder> layers = ((AccessorRenderTypeBuffers)Minecraft.func_71410_x().func_228019_au_()).getFixedBuffers();
            layers.put(RenderHelper.MANA_POOL_WATER, new BufferBuilder(RenderHelper.MANA_POOL_WATER.func_228662_o_()));
        });
    }

    private void initAuxiliaryRender() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        PlayerRenderer render = (PlayerRenderer)skinMap.get("default");
        render.func_177094_a((LayerRenderer)new ContributorFancinessHandler((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        render.func_177094_a((LayerRenderer)new ManaTabletRenderHandler((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        render.func_177094_a((LayerRenderer)new LayerTerraHelmet((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        render = (PlayerRenderer)skinMap.get("slim");
        render.func_177094_a((LayerRenderer)new ContributorFancinessHandler((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        render.func_177094_a((LayerRenderer)new ManaTabletRenderHandler((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
        render.func_177094_a((LayerRenderer)new LayerTerraHelmet((IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>>)render));
    }

    @Override
    public boolean isTheClientPlayer(LivingEntity entity) {
        return entity == Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public boolean isClientPlayerWearingMonocle() {
        return ItemMonocle.hasMonocle((LivingEntity)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public long getWorldElapsedTicks() {
        return ClientTickHandler.ticksInGame;
    }

    @Override
    public void lightningFX(Vector3 vectorStart, Vector3 vectorEnd, float ticksPerMeter, long seed, int colorOuter, int colorInner) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new FXLightning(Minecraft.func_71410_x().field_71441_e, vectorStart, vectorEnd, ticksPerMeter, seed, colorOuter, colorInner));
    }

    @Override
    public void addBoss(EntityDoppleganger boss) {
        BossBarHandler.bosses.add(boss);
    }

    @Override
    public void removeBoss(EntityDoppleganger boss) {
        BossBarHandler.bosses.remove((Object)boss);
    }

    @Override
    public int getClientRenderDistance() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    @Override
    public void addParticleForce(World world, IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        world.func_195590_a(particleData, true, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public void addParticleForceNear(World world, IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        ActiveRenderInfo info = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        if (info.func_216786_h() && info.func_216785_c().func_186679_c(x, y, z) <= 1024.0) {
            this.addParticleForce(world, particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    @Override
    public void showMultiblock(IMultiblock mb, ITextComponent name, BlockPos anchor, Rotation rot) {
        PatchouliAPI.get().showMultiblock(mb, name, anchor, rot);
    }

    @Override
    public void clearSextantMultiblock() {
        IMultiblock mb = PatchouliAPI.get().getCurrentMultiblock();
        if (mb != null && mb.getID().equals((Object)ItemSextant.MULTIBLOCK_ID)) {
            PatchouliAPI.get().clearMultiblock();
        }
    }

    @Override
    public Item.Properties propertiesWithRenderer(Item.Properties properties, Block block) {
        if (block instanceof BlockPylon) {
            return properties.setISTER(() -> RenderTilePylon.TEISR::new);
        }
        return properties.setISTER(() -> () -> new TEISR(block));
    }
}

