/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile.functional;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;

public class SubTileMarimorphosis
extends TileEntityFunctionalFlower {
    private static final int COST = 12;
    private static final int RANGE = 8;
    private static final int RANGE_Y = 5;
    private static final int RANGE_MINI = 2;
    private static final int RANGE_Y_MINI = 1;

    public SubTileMarimorphosis(TileEntityType<?> type) {
        super(type);
    }

    public SubTileMarimorphosis() {
        this(ModSubtiles.MARIMORPHOSIS);
    }

    @Override
    public void tickFlower() {
        BlockState state;
        BlockPos coords;
        super.tickFlower();
        if (this.func_145831_w().field_72995_K || this.redstoneSignal > 0) {
            return;
        }
        if (this.getMana() >= 12 && this.ticksExisted % 2 == 0 && (coords = this.getCoordsToPut()) != null && (state = this.getStoneToPut(coords)) != null) {
            this.func_145831_w().func_175656_a(coords, state);
            if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue()) {
                this.func_145831_w().func_217379_c(2001, coords, Block.func_196246_j((BlockState)state));
            }
            this.addMana(-12);
            this.sync();
        }
    }

    public BlockState getStoneToPut(BlockPos coords) {
        Biome.Category category = this.func_145831_w().func_226691_t_(coords).func_201856_r();
        ArrayList<StoneEntry> values = new ArrayList<StoneEntry>();
        for (Type type : Type.values()) {
            values.add(new StoneEntry(type, type.contains(category) ? 12 : 1));
        }
        return ((StoneEntry)WeightedRandom.func_76271_a((Random)this.func_145831_w().field_73012_v, values)).type.biomeStone.func_176223_P();
    }

    private BlockPos getCoordsToPut() {
        ArrayList<BlockPos> possibleCoords = new ArrayList<BlockPos>();
        int range = this.getRange();
        int rangeY = this.getRangeY();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)this.getEffectivePos().func_177982_a(-range, -rangeY, -range), (BlockPos)this.getEffectivePos().func_177982_a(range, rangeY, range))) {
            BlockState state = this.func_145831_w().func_180495_p(pos);
            if (state.func_177230_c() != Blocks.field_150348_b) continue;
            possibleCoords.add(pos.func_185334_h());
        }
        if (possibleCoords.isEmpty()) {
            return null;
        }
        return (BlockPos)possibleCoords.get(this.func_145831_w().field_73012_v.nextInt(possibleCoords.size()));
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), this.getRange());
    }

    public int getRange() {
        return 8;
    }

    public int getRangeY() {
        return 5;
    }

    @Override
    public int getColor() {
        return 7772311;
    }

    @Override
    public boolean acceptsRedstone() {
        return true;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }

    public static class Mini
    extends SubTileMarimorphosis {
        public Mini() {
            super(ModSubtiles.MARIMORPHOSIS_CHIBI);
        }

        @Override
        public int getRange() {
            return 2;
        }

        @Override
        public int getRangeY() {
            return 1;
        }
    }

    private static class StoneEntry
    extends WeightedRandom.Item {
        private final Type type;

        public StoneEntry(Type type, int weight) {
            super(weight);
            this.type = type;
        }
    }

    private static enum Type {
        FOREST(ModFluffBlocks.biomeStoneForest, Biome.Category.FOREST),
        PLAINS(ModFluffBlocks.biomeStonePlains, Biome.Category.PLAINS),
        MOUNTAIN(ModFluffBlocks.biomeStoneMountain, Biome.Category.EXTREME_HILLS),
        MUSHROOM(ModFluffBlocks.biomeStoneFungal, Biome.Category.MUSHROOM),
        SWAMP(ModFluffBlocks.biomeStoneSwamp, Biome.Category.SWAMP),
        SANDY(ModFluffBlocks.biomeStoneDesert, Biome.Category.DESERT, Biome.Category.BEACH),
        COLD(ModFluffBlocks.biomeStoneTaiga, Biome.Category.ICY, Biome.Category.TAIGA),
        MESA(ModFluffBlocks.biomeStoneMesa, Biome.Category.MESA);

        private final Block biomeStone;
        private final Biome.Category[] categories;

        private Type(Block biomeStone, Biome.Category ... categories) {
            this.biomeStone = biomeStone;
            this.categories = categories;
        }

        public boolean contains(Biome.Category category) {
            for (Biome.Category c : this.categories) {
                if (c != category) continue;
                return true;
            }
            return false;
        }
    }
}

