/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import vazkii.botania.common.block.BlockLightRelay;
import vazkii.botania.common.block.BlockModDoubleFlower;
import vazkii.botania.common.block.BlockModFlower;
import vazkii.botania.common.block.BlockSpecialFlower;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.decor.BlockModMushroom;
import vazkii.botania.common.block.decor.BlockMotifFlower;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.mana.BlockSpreader;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.material.ItemPetal;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.data.BlockstateProvider;

public class ItemModelProvider
extends net.minecraftforge.client.model.generators.ItemModelProvider {
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");
    private static final ResourceLocation HANDHELD = new ResourceLocation("item/handheld");

    public ItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "botania", existingFileHelper);
    }

    protected void registerModels() {
        Set<Item> items = Registry.field_212630_s.func_201756_e().filter(i -> "botania".equals(Registry.field_212630_s.func_177774_c(i).func_110624_b())).collect(Collectors.toSet());
        this.registerItemBlocks(BlockstateProvider.takeAll(items, i -> i instanceof BlockItem).stream().map(i -> (BlockItem)i).collect(Collectors.toSet()));
        this.registerItemOverrides(items);
        this.registerItems(items);
    }

    private static String name(Item i) {
        return Registry.field_212630_s.func_177774_c((Object)i).func_110623_a();
    }

    private ItemModelBuilder handheldItem(String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, HANDHELD)).texture("layer0", ResourceLocationHelper.prefix("item/" + name));
    }

    private ItemModelBuilder handheldItem(Item i) {
        return this.handheldItem(ItemModelProvider.name(i));
    }

    private ItemModelBuilder generatedItem(String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", ResourceLocationHelper.prefix("item/" + name));
    }

    private ItemModelBuilder generatedItem(Item i) {
        return this.generatedItem(ItemModelProvider.name(i));
    }

    private void registerItems(Set<Item> items) {
        items.remove(ModItems.manaGun);
        BlockstateProvider.takeAll(items, i -> i instanceof ItemLens).forEach(i -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ItemModelProvider.name(i), GENERATED)).texture("layer0", ResourceLocationHelper.prefix("item/lens"))).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(i)));
        });
        this.generatedItem(ModItems.bloodPendant).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.bloodPendant) + "_overlay"));
        items.remove(ModItems.bloodPendant);
        this.handheldItem(ModItems.enderDagger).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.enderDagger) + "_overlay"));
        items.remove(ModItems.enderDagger);
        this.generatedItem(ModItems.incenseStick).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.incenseStick) + "_overlay"));
        items.remove(ModItems.incenseStick);
        this.generatedItem(ModItems.manaMirror).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.manaMirror) + "_overlay"));
        items.remove(ModItems.manaMirror);
        this.generatedItem(ModItems.manaTablet).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.manaTablet) + "_overlay"));
        items.remove(ModItems.manaTablet);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ItemModelProvider.name(ModItems.thirdEye), GENERATED)).texture("layer0", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.thirdEye) + "_0"))).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.thirdEye) + "_1"))).texture("layer2", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.thirdEye) + "_2"));
        items.remove(ModItems.thirdEye);
        BlockstateProvider.takeAll(items, ModItems.cobbleRod, ModItems.dirtRod, ModItems.diviningRod, ModItems.elementiumAxe, ModItems.elementiumPick, ModItems.elementiumShovel, ModItems.elementiumHoe, ModItems.elementiumSword, ModItems.exchangeRod, ModItems.fireRod, ModItems.glassPick, ModItems.gravityRod, ModItems.manasteelAxe, ModItems.manasteelPick, ModItems.manasteelShears, ModItems.manasteelShovel, ModItems.manasteelHoe, ModItems.missileRod, ModItems.obedienceStick, ModItems.rainbowRod, ModItems.smeltRod, ModItems.starSword, ModItems.terraSword, ModItems.terraformRod, ModItems.thunderSword, ModItems.waterRod, ModItems.kingKey, ModItems.skyDirtRod).forEach(this::handheldItem);
        BlockstateProvider.takeAll(items, i -> true).forEach(this::generatedItem);
    }

    private void registerItemOverrides(Set<Item> items) {
        items.remove(ModItems.livingwoodBow);
        items.remove(ModItems.crystalBow);
        this.generatedItem(ModItems.blackHoleTalisman).override().predicate(ResourceLocationHelper.prefix("active"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.blackHoleTalisman) + "_active")).end();
        items.remove(ModItems.blackHoleTalisman);
        ItemModelBuilder flaskBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ItemModelProvider.name(ModItems.brewFlask), GENERATED)).texture("layer0", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.flask)))).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.brewFlask) + "_0"));
        for (int i = 1; i <= 5; ++i) {
            String overrideName = ItemModelProvider.name(ModItems.brewFlask) + "_" + i;
            ModelBuilder overrideModel = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(overrideName, GENERATED)).texture("layer0", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.flask)))).texture("layer1", ResourceLocationHelper.prefix("item/" + overrideName));
            flaskBuilder.override().predicate(ResourceLocationHelper.prefix("swigs_taken"), (float)i).model((ModelFile)overrideModel).end();
        }
        items.remove(ModItems.brewFlask);
        ItemModelBuilder vialBuilder = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ItemModelProvider.name(ModItems.brewVial), GENERATED)).texture("layer0", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.vial)))).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.brewVial) + "_0"));
        for (int i = 1; i <= 3; ++i) {
            String overrideName = ItemModelProvider.name(ModItems.brewVial) + "_" + i;
            ModelBuilder overrideModel = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(overrideName, GENERATED)).texture("layer0", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.vial)))).texture("layer1", ResourceLocationHelper.prefix("item/" + overrideName));
            vialBuilder.override().predicate(ResourceLocationHelper.prefix("swigs_taken"), (float)i).model((ModelFile)overrideModel).end();
        }
        items.remove(ModItems.brewVial);
        this.handheldItem(ModItems.elementiumShears).override().predicate(ResourceLocationHelper.prefix("reddit"), 1.0f).model((ModelFile)this.handheldItem("dammitreddit")).end();
        items.remove(ModItems.elementiumShears);
        ItemModelBuilder vuvuzela = this.handheldItem("vuvuzela");
        this.generatedItem(ModItems.grassHorn).override().predicate(ResourceLocationHelper.prefix("vuvuzela"), 1.0f).model((ModelFile)vuvuzela).end();
        this.generatedItem(ModItems.leavesHorn).override().predicate(ResourceLocationHelper.prefix("vuvuzela"), 1.0f).model((ModelFile)vuvuzela).end();
        this.generatedItem(ModItems.snowHorn).override().predicate(ResourceLocationHelper.prefix("vuvuzela"), 1.0f).model((ModelFile)vuvuzela).end();
        items.remove(ModItems.grassHorn);
        items.remove(ModItems.leavesHorn);
        items.remove(ModItems.snowHorn);
        this.generatedItem(ModItems.infiniteFruit).override().predicate(ResourceLocationHelper.prefix("boot"), 1.0f).model((ModelFile)this.generatedItem("dasboot")).end();
        items.remove(ModItems.infiniteFruit);
        this.generatedItem(ModItems.lexicon).override().predicate(ResourceLocationHelper.prefix("elven"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.lexicon) + "_elven")).end();
        items.remove(ModItems.lexicon);
        this.generatedItem(ModItems.magnetRing).override().predicate(ResourceLocationHelper.prefix("active"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.magnetRing) + "_active")).end();
        items.remove(ModItems.magnetRing);
        this.generatedItem(ModItems.magnetRingGreater).override().predicate(ResourceLocationHelper.prefix("active"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.magnetRingGreater) + "_active")).end();
        items.remove(ModItems.magnetRingGreater);
        ItemModelBuilder bottle = this.generatedItem(ModItems.manaBottle);
        for (int i = 1; i <= 5; ++i) {
            ItemModelBuilder overrideModel = this.generatedItem(ItemModelProvider.name(ModItems.manaBottle) + "_" + i);
            bottle.override().predicate(ResourceLocationHelper.prefix("swigs_taken"), (float)i).model((ModelFile)overrideModel).end();
        }
        items.remove(ModItems.manaBottle);
        this.generatedItem(ModItems.manaCookie).override().predicate(ResourceLocationHelper.prefix("totalbiscuit"), 1.0f).model((ModelFile)this.generatedItem("totalbiscuit")).end();
        items.remove(ModItems.manaCookie);
        this.handheldItem(ModItems.manasteelSword).override().predicate(ResourceLocationHelper.prefix("elucidator"), 1.0f).model((ModelFile)this.handheldItem("elucidator")).end();
        items.remove(ModItems.manasteelSword);
        this.generatedItem(ModItems.manaweaveHelm).override().predicate(ResourceLocationHelper.prefix("holiday"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.manaweaveHelm) + "_holiday")).end();
        items.remove(ModItems.manaweaveHelm);
        this.generatedItem(ModItems.manaweaveChest).override().predicate(ResourceLocationHelper.prefix("holiday"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.manaweaveChest) + "_holiday")).end();
        items.remove(ModItems.manaweaveChest);
        this.generatedItem(ModItems.manaweaveLegs).override().predicate(ResourceLocationHelper.prefix("holiday"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.manaweaveLegs) + "_holiday")).end();
        items.remove(ModItems.manaweaveLegs);
        this.generatedItem(ModItems.manaweaveBoots).override().predicate(ResourceLocationHelper.prefix("holiday"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.manaweaveBoots) + "_holiday")).end();
        items.remove(ModItems.manaweaveBoots);
        this.generatedItem(ModItems.slimeBottle).override().predicate(ResourceLocationHelper.prefix("active"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.slimeBottle) + "_active")).end();
        items.remove(ModItems.slimeBottle);
        this.generatedItem(ModItems.spawnerMover).override().predicate(ResourceLocationHelper.prefix("full"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.spawnerMover) + "_full")).end();
        items.remove(ModItems.spawnerMover);
        this.generatedItem(ModItems.temperanceStone).override().predicate(ResourceLocationHelper.prefix("active"), 1.0f).model((ModelFile)this.generatedItem(ItemModelProvider.name(ModItems.temperanceStone) + "_active")).end();
        items.remove(ModItems.temperanceStone);
        this.handheldItem(ModItems.terraAxe).override().predicate(ResourceLocationHelper.prefix("active"), 1.0f).model((ModelFile)this.handheldItem(ItemModelProvider.name(ModItems.terraAxe) + "_active")).end();
        items.remove(ModItems.terraAxe);
        ModelBuilder enabledModel = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ItemModelProvider.name(ModItems.terraPick) + "_active", HANDHELD)).texture("layer0", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.terraPick)))).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.terraPick) + "_active"));
        ModelBuilder tippedEnabledModel = ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ItemModelProvider.name(ModItems.terraPick) + "_tipped_active", HANDHELD)).texture("layer0", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.terraPick) + "_tipped"))).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.terraPick) + "_active"));
        this.handheldItem(ModItems.terraPick).override().predicate(ResourceLocationHelper.prefix("active"), 1.0f).model((ModelFile)enabledModel).end().override().predicate(ResourceLocationHelper.prefix("tipped"), 1.0f).model((ModelFile)this.handheldItem(ItemModelProvider.name(ModItems.terraPick) + "_tipped")).end().override().predicate(ResourceLocationHelper.prefix("tipped"), 1.0f).predicate(ResourceLocationHelper.prefix("active"), 1.0f).model((ModelFile)tippedEnabledModel).end();
        items.remove(ModItems.terraPick);
        this.handheldItem(ModItems.tornadoRod).override().predicate(ResourceLocationHelper.prefix("active"), 1.0f).model((ModelFile)this.handheldItem(ItemModelProvider.name(ModItems.tornadoRod) + "_active")).end();
        items.remove(ModItems.tornadoRod);
        ModelBuilder twigwandBind = ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(ItemModelProvider.name(ModItems.twigWand) + "_bind", HANDHELD)).texture("layer0", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.twigWand)))).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.twigWand) + "_top"))).texture("layer2", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.twigWand) + "_bottom"))).texture("layer3", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.twigWand) + "_bind"));
        ((ItemModelBuilder)((ItemModelBuilder)this.handheldItem(ModItems.twigWand).texture("layer1", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.twigWand) + "_top"))).texture("layer2", ResourceLocationHelper.prefix("item/" + ItemModelProvider.name(ModItems.twigWand) + "_bottom"))).override().predicate(ResourceLocationHelper.prefix("bindmode"), 1.0f).model((ModelFile)twigwandBind).end();
        items.remove(ModItems.twigWand);
    }

    private void registerItemBlocks(Set<BlockItem> itemBlocks) {
        itemBlocks.remove(ModBlocks.corporeaCrystalCube.func_199767_j());
        String animatedTorchName = Registry.field_212630_s.func_177774_c((Object)ModBlocks.animatedTorch.func_199767_j()).func_110623_a();
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(animatedTorchName, "item/generated")).texture("layer0", new ResourceLocation("block/redstone_torch"))).texture("layer1", ResourceLocationHelper.prefix("block/animated_torch_glimmer"));
        itemBlocks.remove(ModBlocks.animatedTorch.func_199767_j());
        String gaiaHeadName = Registry.field_212630_s.func_177774_c((Object)ModBlocks.gaiaHead.func_199767_j()).func_110623_a();
        this.withExistingParent(gaiaHeadName, "item/template_skull");
        itemBlocks.remove(ModBlocks.gaiaHead.func_199767_j());
        BlockstateProvider.takeAll(itemBlocks, i -> i.func_179223_d() instanceof BlockModDoubleFlower).forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            ((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", ResourceLocationHelper.prefix("block/" + name + "_top"));
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.func_179223_d() instanceof BlockPetalBlock).forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            this.withExistingParent(name, ResourceLocationHelper.prefix("block/petal_block"));
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.func_179223_d() instanceof PaneBlock).forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            String baseName = name.substring(0, name.length() - "_pane".length());
            ((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", ResourceLocationHelper.prefix("block/" + baseName));
        });
        Predicate<BlockItem> defaultGenerated = i -> {
            Block b = i.func_179223_d();
            return b instanceof BlockSpecialFlower || b instanceof BlockModMushroom || b instanceof BlockLightRelay || b instanceof BlockModFlower || b == ModBlocks.ghostRail;
        };
        BlockstateProvider.takeAll(itemBlocks, defaultGenerated).forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            ((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", ResourceLocationHelper.prefix("block/" + name));
        });
        BlockstateProvider.takeAll(itemBlocks, b -> b.func_179223_d() instanceof BlockMotifFlower).forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            ((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", ResourceLocationHelper.prefix("block/" + name.replace("_motif", "")));
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.func_179223_d() instanceof BlockPool).forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            ((ItemModelBuilder)this.withExistingParent(name, ResourceLocationHelper.prefix("block/" + name))).override().predicate(ResourceLocationHelper.prefix("full"), 1.0f).model((ModelFile)this.getExistingFile(ResourceLocationHelper.prefix("block/" + name + "_full"))).end();
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.func_179223_d() instanceof WallBlock).forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            String baseName = name.substring(0, name.length() - "_wall".length());
            ((ItemModelBuilder)this.withExistingParent(name, new ResourceLocation("block/wall_inventory"))).texture("wall", ResourceLocationHelper.prefix("block/" + baseName));
        });
        BlockstateProvider.takeAll(itemBlocks, i -> i.func_179223_d() instanceof BlockSpreader).forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            String material = i.func_179223_d() == ModBlocks.elvenSpreader ? "dreamwood" : (i.func_179223_d() == ModBlocks.gaiaSpreader ? name + "_material" : "livingwood");
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, ResourceLocationHelper.prefix("block/shapes/spreader_item"))).texture("side", ResourceLocationHelper.prefix("block/" + name + "_side"))).texture("material", ResourceLocationHelper.prefix("block/" + material))).texture("inside", ResourceLocationHelper.prefix("block/" + name + "_inside"));
        });
        BlockstateProvider.takeAll(itemBlocks, ModBlocks.avatar.func_199767_j(), ModBlocks.bellows.func_199767_j(), ModBlocks.brewery.func_199767_j(), ModBlocks.corporeaIndex.func_199767_j(), ModBlocks.gaiaPylon.func_199767_j(), ModBlocks.hourglass.func_199767_j(), ModBlocks.manaPylon.func_199767_j(), ModBlocks.naturaPylon.func_199767_j(), ModBlocks.teruTeruBozu.func_199767_j()).forEach(this::builtinEntity);
        BlockstateProvider.takeAll(itemBlocks, i -> i instanceof ItemPetal).forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            ((ItemModelBuilder)this.withExistingParent(name, "item/generated")).texture("layer0", ResourceLocationHelper.prefix("item/petal"));
        });
        String dreamwoodFenceName = Registry.field_212630_s.func_177774_c((Object)ModFluffBlocks.dreamwoodFence.func_199767_j()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(dreamwoodFenceName, "block/fence_inventory")).texture("texture", ResourceLocationHelper.prefix("block/dreamwood_planks"));
        itemBlocks.remove(ModFluffBlocks.dreamwoodFence.func_199767_j());
        String livingwoodFenceName = Registry.field_212630_s.func_177774_c((Object)ModFluffBlocks.livingwoodFence.func_199767_j()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(livingwoodFenceName, "block/fence_inventory")).texture("texture", ResourceLocationHelper.prefix("block/livingwood_planks"));
        itemBlocks.remove(ModFluffBlocks.livingwoodFence.func_199767_j());
        String elfGlassName = Registry.field_212630_s.func_177774_c((Object)ModBlocks.elfGlass.func_199767_j()).func_110623_a();
        this.withExistingParent(elfGlassName, ResourceLocationHelper.prefix("block/elf_glass_0"));
        itemBlocks.remove(ModBlocks.elfGlass.func_199767_j());
        itemBlocks.forEach(i -> {
            String name = Registry.field_212630_s.func_177774_c(i).func_110623_a();
            this.withExistingParent(name, ResourceLocationHelper.prefix("block/" + name));
        });
    }

    private void builtinEntity(Item i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i).func_110623_a();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("builtin/entity"))).transforms().transform(ModelBuilder.Perspective.GUI).rotation(30.0f, 45.0f, 0.0f).scale(0.625f).end().transform(ModelBuilder.Perspective.GROUND).translation(0.0f, 3.0f, 0.0f).scale(0.25f).end().transform(ModelBuilder.Perspective.HEAD).rotation(0.0f, 180.0f, 0.0f).end().transform(ModelBuilder.Perspective.FIXED).rotation(0.0f, 180.0f, 0.0f).scale(0.5f).end().transform(ModelBuilder.Perspective.THIRDPERSON_RIGHT).rotation(75.0f, 315.0f, 0.0f).translation(0.0f, 2.5f, 0.0f).scale(0.375f).end().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, 315.0f, 0.0f).scale(0.4f).end().end();
    }

    @Nonnull
    public String func_200397_b() {
        return "Botania item models";
    }
}

