/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat;

import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.voicechat.ClientConfig;
import de.maxhenkel.voicechat.PlayerVolumeConfig;
import de.maxhenkel.voicechat.ServerConfig;
import de.maxhenkel.voicechat.command.VoicechatCommands;
import de.maxhenkel.voicechat.corelib.CommonRegistry;
import de.maxhenkel.voicechat.net.AuthenticationMessage;
import de.maxhenkel.voicechat.net.PlayerStateMessage;
import de.maxhenkel.voicechat.net.PlayerStatesMessage;
import de.maxhenkel.voicechat.net.SetGroupMessage;
import de.maxhenkel.voicechat.net.SetPlayerStateMessage;
import de.maxhenkel.voicechat.resourcepacks.VoiceChatResourcePack;
import de.maxhenkel.voicechat.voice.client.ClientVoiceEvents;
import de.maxhenkel.voicechat.voice.server.ServerVoiceEvents;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.command.CommandSource;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="voicechat")
public class Main {
    public static final String MODID = "voicechat";
    public static final Logger LOGGER = LogManager.getLogger((String)"voicechat");
    public static SimpleChannel SIMPLE_CHANNEL;
    public static int PROTOCOL_VERSION;
    public static ServerConfig SERVER_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    public static PlayerVolumeConfig VOLUME_CONFIG;
    public static ServerVoiceEvents SERVER;
    @OnlyIn(value=Dist.CLIENT)
    public static ClientVoiceEvents CLIENT_VOICE_EVENTS;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_PTT;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_MUTE;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_DISABLE;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_VOICE_CHAT;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_HIDE_ICONS;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_VOICE_CHAT_SETTINGS;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_GROUP;
    @OnlyIn(value=Dist.CLIENT)
    public static KeyBinding KEY_TOGGLE_RECORDING;
    public static final Pattern GROUP_REGEX;
    public static VoiceChatResourcePack CLASSIC_ICONS;
    public static VoiceChatResourcePack WHITE_ICONS;
    public static VoiceChatResourcePack BLACK_ICONS;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class);
        VOLUME_CONFIG = new PlayerVolumeConfig();
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        SERVER = new ServerVoiceEvents();
        MinecraftForge.EVENT_BUS.register((Object)SERVER);
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default", PROTOCOL_VERSION);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, AuthenticationMessage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, PlayerStateMessage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 2, PlayerStatesMessage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 3, SetPlayerStateMessage.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 4, SetGroupMessage.class);
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        CLIENT_VOICE_EVENTS = new ClientVoiceEvents();
        MinecraftForge.EVENT_BUS.register((Object)CLIENT_VOICE_EVENTS);
        KEY_PTT = new KeyBinding("key.push_to_talk", 280, "key.categories.voicechat");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_PTT);
        KEY_MUTE = new KeyBinding("key.mute_microphone", 77, "key.categories.voicechat");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_MUTE);
        KEY_DISABLE = new KeyBinding("key.disable_voice_chat", 78, "key.categories.voicechat");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_DISABLE);
        KEY_HIDE_ICONS = new KeyBinding("key.hide_icons", 72, "key.categories.voicechat");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_HIDE_ICONS);
        KEY_VOICE_CHAT = new KeyBinding("key.voice_chat", 86, "key.categories.voicechat");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_VOICE_CHAT);
        KEY_VOICE_CHAT_SETTINGS = new KeyBinding("key.voice_chat_settings", InputMappings.field_197958_a.func_197937_c(), "key.categories.voicechat");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_VOICE_CHAT_SETTINGS);
        KEY_GROUP = new KeyBinding("key.voice_chat_group", 71, "key.categories.voicechat");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_GROUP);
        KEY_TOGGLE_RECORDING = new KeyBinding("key.voice_chat_toggle_recording", InputMappings.field_197958_a.func_197937_c(), "key.categories.voicechat");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_TOGGLE_RECORDING);
        CLASSIC_ICONS = new VoiceChatResourcePack("Classic Icons", "classic_icons");
        WHITE_ICONS = new VoiceChatResourcePack("White Icons", "white_icons");
        BLACK_ICONS = new VoiceChatResourcePack("Black Icons", "black_icons");
        ResourcePackList repository = Minecraft.func_71410_x().func_195548_H();
        repository.addPackFinder((consumer, packConstructor) -> {
            consumer.accept(ResourcePackInfo.func_195793_a((String)CLASSIC_ICONS.func_195762_a(), (boolean)false, () -> CLASSIC_ICONS, (ResourcePackInfo.IFactory)packConstructor, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_));
            consumer.accept(ResourcePackInfo.func_195793_a((String)WHITE_ICONS.func_195762_a(), (boolean)false, () -> WHITE_ICONS, (ResourcePackInfo.IFactory)packConstructor, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_));
            consumer.accept(ResourcePackInfo.func_195793_a((String)BLACK_ICONS.func_195762_a(), (boolean)false, () -> BLACK_ICONS, (ResourcePackInfo.IFactory)packConstructor, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP, (IPackNameDecorator)IPackNameDecorator.field_232626_b_));
        });
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartedEvent event) {
        SERVER.serverStarting(event);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        VoicechatCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    static {
        PROTOCOL_VERSION = 4;
        GROUP_REGEX = Pattern.compile("^\\S[^\"\\n\\r\\t]{0,15}$");
    }
}

