/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.corelib.net.NetUtils;
import de.maxhenkel.voicechat.net.SetGroupMessage;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.Server;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class VoicechatCommands {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder literalBuilder = Commands.func_197057_a((String)"voicechat");
        literalBuilder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"test").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(commandSource -> {
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)commandSource, (String)"target");
            Server server = Main.SERVER.getServer();
            if (server == null) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            ClientConnection clientConnection = server.getConnections().get(player.func_110124_au());
            if (clientConnection == null) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.client_not_connected"), false);
                return 1;
            }
            try {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.sending_packet"), false);
                final long timestamp = System.currentTimeMillis();
                server.getPingManager().sendPing(clientConnection, 5000L, new PingManager.PingListener(){

                    @Override
                    public void onPong(PingPacket packet) {
                        ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.packet_received", new Object[]{System.currentTimeMillis() - timestamp}), false);
                    }

                    @Override
                    public void onTimeout() {
                        ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.packet_timed_out"), false);
                    }
                });
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.packet_sent_waiting"), false);
            }
            catch (Exception e) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.failed_to_send_packet", new Object[]{e.getMessage()}), false);
                e.printStackTrace();
                return 1;
            }
            return 1;
        })));
        literalBuilder.then(Commands.func_197057_a((String)"invite").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(commandSource -> {
            ServerPlayerEntity source = ((CommandSource)commandSource.getSource()).func_197035_h();
            Server server = Main.SERVER.getServer();
            if (server == null) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            PlayerState state = server.getPlayerStateManager().getState(source.func_110124_au());
            if (state == null || !state.hasGroup()) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.not_in_group"), false);
                return 1;
            }
            ServerPlayerEntity player = EntityArgument.func_197089_d((CommandContext)commandSource, (String)"target");
            player.func_145747_a((ITextComponent)new TranslationTextComponent("message.voicechat.invite", new Object[]{source.func_145748_c_(), new StringTextComponent(state.getGroup()).func_240699_a_(TextFormatting.GRAY), TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("message.voicechat.accept_invite").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/voicechat join \"" + state.getGroup() + "\"")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("message.voicechat.accept_invite.hover"))))).func_240699_a_(TextFormatting.GREEN)}), Util.field_240973_b_);
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.invite_successful", new Object[]{player.func_145748_c_()}), false);
            return 1;
        })));
        literalBuilder.then(Commands.func_197057_a((String)"join").then(Commands.func_197056_a((String)"group", (ArgumentType)StringArgumentType.string()).executes(commandSource -> {
            if (!((Boolean)Main.SERVER_CONFIG.groupsEnabled.get()).booleanValue()) {
                ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.voicechat.groups_disabled"));
                return 1;
            }
            Server server = Main.SERVER.getServer();
            if (server == null) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            ServerPlayerEntity source = ((CommandSource)commandSource.getSource()).func_197035_h();
            String groupName = StringArgumentType.getString((CommandContext)commandSource, (String)"group");
            if (groupName.length() > 16) {
                ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.voicechat.group_name_too_long"));
                return 1;
            }
            if (!Main.GROUP_REGEX.matcher(groupName).matches()) {
                ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.voicechat.invalid_group_name"));
                return 1;
            }
            NetUtils.sendTo(Main.SIMPLE_CHANNEL, source, new SetGroupMessage(groupName));
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.join_successful", new Object[]{new StringTextComponent(groupName).func_240699_a_(TextFormatting.GRAY)}), false);
            return 1;
        })));
        literalBuilder.then(Commands.func_197057_a((String)"leave").executes(commandSource -> {
            if (!((Boolean)Main.SERVER_CONFIG.groupsEnabled.get()).booleanValue()) {
                ((CommandSource)commandSource.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("message.voicechat.groups_disabled"));
                return 1;
            }
            Server server = Main.SERVER.getServer();
            if (server == null) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.voice_chat_unavailable"), false);
                return 1;
            }
            ServerPlayerEntity source = ((CommandSource)commandSource.getSource()).func_197035_h();
            PlayerState state = server.getPlayerStateManager().getState(source.func_110124_au());
            if (state == null || !state.hasGroup()) {
                ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.not_in_group"), false);
                return 1;
            }
            NetUtils.sendTo(Main.SIMPLE_CHANNEL, source, new SetGroupMessage(""));
            ((CommandSource)commandSource.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("message.voicechat.leave_successful"), false);
            return 1;
        }));
        dispatcher.register(literalBuilder);
    }
}

