/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.gui.CreateGroupScreen;
import de.maxhenkel.voicechat.gui.GroupScreen;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import java.util.Collections;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class VoiceChatScreen
extends VoiceChatScreenBase {
    protected static final int FONT_COLOR = 0x404040;
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_voicechat.png");
    private static final ResourceLocation MICROPHONE = new ResourceLocation("voicechat", "textures/gui/microphone_button.png");
    private static final ResourceLocation HIDE = new ResourceLocation("voicechat", "textures/gui/hide_button.png");
    private static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/gui/speaker_button.png");
    private static final ResourceLocation RECORD = new ResourceLocation("voicechat", "textures/gui/record_button.png");
    private ToggleImageButton mute;
    private VoiceChatScreenBase.HoverArea recordingHoverArea;

    public VoiceChatScreen() {
        super((ITextComponent)new TranslationTextComponent("gui.voicechat.voice_chat.title"), 195, 76);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        ClientPlayerStateManager stateManager = Main.CLIENT_VOICE_EVENTS.getPlayerStateManager();
        this.mute = new ToggleImageButton(this.guiLeft + 6, this.guiTop + this.ySize - 6 - 20, MICROPHONE, stateManager::isMuted, button -> stateManager.setMuted(!stateManager.isMuted()), (button, matrices, mouseX, mouseY) -> this.func_238654_b_(matrices, Collections.singletonList(new TranslationTextComponent("message.voicechat.mute_microphone").func_241878_f()), mouseX, mouseY));
        this.func_230480_a_(this.mute);
        ToggleImageButton disable = new ToggleImageButton(this.guiLeft + 6 + 20 + 2, this.guiTop + this.ySize - 6 - 20, SPEAKER, stateManager::isDisabled, button -> stateManager.setDisabled(!stateManager.isDisabled()), (button, matrices, mouseX, mouseY) -> this.func_238654_b_(matrices, Collections.singletonList(new TranslationTextComponent("message.voicechat.disable_voice_chat").func_241878_f()), mouseX, mouseY));
        this.func_230480_a_(disable);
        if (((Boolean)Main.SERVER_CONFIG.allowRecording.get()).booleanValue()) {
            ToggleImageButton record = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20 - 2 - 20, this.guiTop + this.ySize - 6 - 20, RECORD, () -> Main.CLIENT_VOICE_EVENTS.getClient() != null && Main.CLIENT_VOICE_EVENTS.getClient().getRecorder() != null, button -> {
                Client client = Main.CLIENT_VOICE_EVENTS.getClient();
                if (client == null) {
                    return;
                }
                client.toggleRecording();
            }, (button, matrices, mouseX, mouseY) -> this.func_238654_b_(matrices, Collections.singletonList(new TranslationTextComponent("message.voicechat.toggle_recording").func_241878_f()), mouseX, mouseY));
            this.func_230480_a_(record);
        }
        ToggleImageButton hide = new ToggleImageButton(this.guiLeft + this.xSize - 6 - 20, this.guiTop + this.ySize - 6 - 20, HIDE, () -> ((ForgeConfigSpec.BooleanValue)Main.CLIENT_CONFIG.hideIcons).get(), button -> {
            Main.CLIENT_CONFIG.hideIcons.set((Object)((Boolean)Main.CLIENT_CONFIG.hideIcons.get() == false ? 1 : 0));
            Main.CLIENT_CONFIG.hideIcons.save();
        }, (button, matrices, mouseX, mouseY) -> this.func_238654_b_(matrices, Collections.singletonList(new TranslationTextComponent("message.voicechat.hide_icons").func_241878_f()), mouseX, mouseY));
        this.func_230480_a_(hide);
        Button settings = new Button(this.guiLeft + 6, this.guiTop + 6 + 15, 75, 20, (ITextComponent)new StringTextComponent("Settings"), button -> this.field_230706_i_.func_147108_a((Screen)new VoiceChatSettingsScreen()));
        this.func_230480_a_(settings);
        Button group = new Button(this.guiLeft + this.xSize - 6 - 75 + 1, this.guiTop + 6 + 15, 75, 20, (ITextComponent)new StringTextComponent("Group"), button -> {
            if (stateManager.isInGroup()) {
                this.field_230706_i_.func_147108_a((Screen)new GroupScreen());
            } else {
                this.field_230706_i_.func_147108_a((Screen)new CreateGroupScreen());
            }
        });
        this.func_230480_a_(group);
        group.field_230693_o_ = (Boolean)Main.SERVER_CONFIG.groupsEnabled.get();
        this.recordingHoverArea = new VoiceChatScreenBase.HoverArea(50, this.ySize - 6 - 20, this.xSize - 100, 20);
        this.checkButtons();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.checkButtons();
    }

    private void checkButtons() {
        this.mute.field_230693_o_ = ((MicrophoneActivationType)((Object)Main.CLIENT_CONFIG.microphoneActivationType.get())).equals((Object)MicrophoneActivationType.VOICE);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        TranslationTextComponent title = new TranslationTextComponent("gui.voicechat.voice_chat.title");
        int titleWidth = this.field_230712_o_.func_78256_a(title.getString());
        this.field_230712_o_.func_238422_b_(matrixStack, title.func_241878_f(), (float)(this.guiLeft + (this.xSize - titleWidth) / 2), (float)(this.guiTop + 7), 0x404040);
        Client client = Main.CLIENT_VOICE_EVENTS.getClient();
        if (client != null && client.getRecorder() != null) {
            AudioRecorder recorder = client.getRecorder();
            StringTextComponent time = new StringTextComponent(recorder.getDuration());
            IFormattableTextComponent iFormattableTextComponent = time.func_240699_a_(TextFormatting.DARK_RED);
            float f = this.guiLeft + (this.xSize - this.field_230712_o_.func_238414_a_((ITextProperties)time)) / 2;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)iFormattableTextComponent, f, (float)(this.guiTop + this.ySize - 9 - 7), 0);
            if (this.recordingHoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                this.func_238652_a_(matrixStack, (ITextComponent)new TranslationTextComponent("message.voicechat.storage_size", new Object[]{recorder.getStorage()}), mouseX, mouseY);
            }
        }
    }
}

