/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.Main;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class ListScreen<T>
extends Screen {
    protected static final int FONT_COLOR = 0x404040;
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_generic_small.png");
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;
    protected List<T> elements;
    protected int index;
    protected Button previous;
    protected Button back;
    protected Button next;
    protected Screen parent;

    public ListScreen(Screen parent, List<T> elements, ITextComponent title) {
        super(title);
        this.parent = parent;
        this.elements = elements;
        this.xSize = 248;
        this.ySize = 85;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.previous = new Button(this.guiLeft + 10, this.guiTop + 60, 60, 20, (ITextComponent)new TranslationTextComponent("message.voicechat.previous"), button -> {
            this.index = (this.index - 1 + this.elements.size()) % this.elements.size();
            this.updateCurrentElement();
        });
        this.back = new Button(this.guiLeft + this.xSize / 2 - 30, this.guiTop + 60, 60, 20, (ITextComponent)new TranslationTextComponent("message.voicechat.back"), button -> this.field_230706_i_.func_147108_a(this.parent));
        this.next = new Button(this.guiLeft + this.xSize - 70, this.guiTop + 60, 60, 20, (ITextComponent)new TranslationTextComponent("message.voicechat.next"), button -> {
            this.index = (this.index + 1) % this.elements.size();
            this.updateCurrentElement();
        });
        this.updateCurrentElement();
    }

    public void updateCurrentElement() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.func_230480_a_((Widget)this.previous);
        this.func_230480_a_((Widget)this.back);
        this.func_230480_a_((Widget)this.next);
        if (this.elements.size() <= 1) {
            this.next.field_230694_p_ = false;
            this.previous.field_230694_p_ = false;
        }
    }

    @Nullable
    public T getCurrentElement() {
        if (this.elements.size() <= 0) {
            return null;
        }
        return this.elements.get(this.index);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == this.field_230706_i_.field_71474_y.field_151445_Q.getKey().func_197937_c() || keyCode == Main.KEY_VOICE_CHAT.getKey().func_197937_c()) {
            this.field_230706_i_.func_147108_a(null);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(stack, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.renderText(stack, this.getCurrentElement(), mouseX, mouseY, partialTicks);
    }

    protected abstract void renderText(MatrixStack var1, @Nullable T var2, int var3, int var4, float var5);
}

