/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.authlib.GameProfile;
import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.voice.client.AudioChannelConfig;
import de.maxhenkel.voicechat.voice.client.Client;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class AudioRecorder {
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS");
    private static final GameProfile SYSTEM = new GameProfile(new UUID(0L, 0L), "system");
    private final long timestamp;
    private final Path location;
    private final Client client;
    private Map<UUID, AudioChunk> chunks;
    private Map<UUID, GameProfile> gameProfileLookup;

    public AudioRecorder(Client client) {
        this.client = client;
        this.timestamp = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(this.timestamp);
        String recordingDestination = (String)Main.CLIENT_CONFIG.recordingDestination.get();
        this.location = recordingDestination.trim().isEmpty() ? Minecraft.func_71410_x().field_71412_D.toPath().resolve("voicechat_recordings").resolve(FORMAT.format(cal.getTime())) : Paths.get(recordingDestination, new String[0]);
        this.location.toFile().mkdirs();
        this.chunks = new ConcurrentHashMap<UUID, AudioChunk>();
        this.gameProfileLookup = new ConcurrentHashMap<UUID, GameProfile>();
    }

    public Path getLocation() {
        return this.location;
    }

    public long getStartTime() {
        return this.timestamp;
    }

    public int getRecordedPlayerCount() {
        return this.gameProfileLookup.size();
    }

    public Client getClient() {
        return this.client;
    }

    public String getDuration() {
        long duration = System.currentTimeMillis() - this.timestamp;
        SimpleDateFormat fmt = new SimpleDateFormat(":mm:ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return duration / 3600000L + fmt.format(new Date(duration));
    }

    public String getStorage() {
        AudioFormat format = AudioChannelConfig.getStereoFormat();
        return FileUtils.byteCountToDisplaySize((long)((System.currentTimeMillis() - this.timestamp) * (long)format.getFrameSize() * ((long)format.getFrameRate() / 1000L) * (long)this.getRecordedPlayerCount()));
    }

    private String lookupName(UUID uuid) {
        GameProfile gameProfile = this.gameProfileLookup.get(uuid);
        if (gameProfile == null) {
            return uuid.toString();
        }
        return gameProfile.getName();
    }

    private Path getFilePath(UUID playerUUID, long timestamp) {
        return this.location.resolve(playerUUID.toString()).resolve(timestamp + ".wav");
    }

    public void appendChunk(@Nullable GameProfile profile, long timestamp, byte[] data) throws IOException {
        GameProfile p = profile != null ? profile : SYSTEM;
        this.gameProfileLookup.putIfAbsent(p.getId(), p);
        this.getChunk(p.getId(), timestamp).add(data);
    }

    private void writeChunk(UUID playerUUID, AudioChunk chunk) throws IOException {
        File file = this.getFilePath(playerUUID, chunk.getTimestamp()).toFile();
        file.getParentFile().mkdirs();
        byte[] data = chunk.getBytes();
        AudioRecorder.writeWav(data, AudioChannelConfig.getStereoFormat(), file);
    }

    private static void writeWav(byte[] data, AudioFormat format, File file) throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        AudioSystem.write(new AudioInputStream(stream, format, data.length / format.getFrameSize()), AudioFileFormat.Type.WAVE, file);
    }

    public void writeChunkThreaded(UUID playerUUID) {
        AudioChunk chunk = this.getAndRemoveChunk(playerUUID);
        new Thread(() -> {
            try {
                this.writeChunk(playerUUID, chunk);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    @Nullable
    private AudioChunk getAndRemoveChunk(UUID playerUUID) {
        return this.chunks.remove(playerUUID);
    }

    private AudioChunk getChunk(UUID playerUUID, long timestamp) {
        if (!this.chunks.containsKey(playerUUID)) {
            AudioChunk chunk = new AudioChunk(timestamp);
            this.chunks.put(playerUUID, chunk);
            return chunk;
        }
        return this.chunks.get(playerUUID);
    }

    private void flush() throws IOException {
        for (Map.Entry<UUID, AudioChunk> chunk : this.chunks.entrySet()) {
            this.writeChunk(chunk.getKey(), chunk.getValue());
        }
    }

    public void close() {
        this.save();
    }

    public void save() {
        new Thread(() -> {
            this.send((ITextComponent)new TranslationTextComponent("message.voicechat.processing_recording_session"));
            try {
                this.flush();
                AtomicLong time = new AtomicLong();
                this.convert(progress -> {
                    if (progress.floatValue() >= 1.0f || System.currentTimeMillis() - time.get() > 1000L) {
                        this.send((ITextComponent)new TranslationTextComponent("message.voicechat.processing_progress", new Object[]{new StringTextComponent(String.valueOf((int)(progress.floatValue() * 100.0f))).func_240699_a_(TextFormatting.GRAY)}));
                        time.set(System.currentTimeMillis());
                    }
                });
                this.send((ITextComponent)new TranslationTextComponent("message.voicechat.save_session", new Object[]{new StringTextComponent(this.location.normalize().toString()).func_240699_a_(TextFormatting.GRAY).func_240700_a_(style -> style.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("message.voicechat.open_folder"))).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.location.normalize().toString())))}));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.send((ITextComponent)new TranslationTextComponent("message.voicechat.save_session_failed", new Object[]{e.getMessage()}));
            }
        }).start();
    }

    private void send(ITextComponent msg) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player != null && mc.field_71441_e != null) {
            player.func_145747_a(msg, Util.field_240973_b_);
        } else {
            Main.LOGGER.info(msg.getString());
        }
    }

    private void convert(Consumer<Float> progress) throws UnsupportedAudioFileException, IOException {
        String[] directories = this.location.toFile().list();
        if (directories == null) {
            return;
        }
        for (int i = 0; i < directories.length; ++i) {
            UUID uuid;
            String directory = directories[i];
            float progressPerc = (float)i / (float)directories.length;
            try {
                uuid = UUID.fromString(directory);
            }
            catch (Exception e) {
                return;
            }
            File userDir = this.location.resolve(directory).toFile();
            File[] files = userDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".wav"));
            RandomAccessAudio audio = this.convertFiles(files, p -> progress.accept(Float.valueOf(progressPerc + p.floatValue() * (1.0f / (float)directories.length))));
            if (audio == null) {
                return;
            }
            AudioRecorder.writeWav(audio.getBytes(), audio.getAudioFormat(), this.location.resolve(this.lookupName(uuid) + ".wav").toFile());
            FileUtils.deleteDirectory((File)userDir);
        }
    }

    @Nullable
    private RandomAccessAudio convertFiles(File[] files, Consumer<Float> progress) throws UnsupportedAudioFileException, IOException {
        List audioSnippets = Arrays.stream(files).map(file -> {
            String[] split = file.getName().split("\\.");
            if (split.length != 2) {
                return null;
            }
            try {
                long num = Long.parseLong(split[0]);
                return new Tuple(file, (Object)num);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        RandomAccessAudio audio = null;
        for (int i = 0; i < audioSnippets.size(); ++i) {
            Tuple snippet = (Tuple)audioSnippets.get(i);
            FileInputStream fis = new FileInputStream((File)snippet.func_76341_a());
            BufferedInputStream bis = new BufferedInputStream(fis);
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(bis);
            if (audio == null) {
                audio = new RandomAccessAudio(audioInputStream.getFormat());
            } else if (!audioInputStream.getFormat().matches(audio.getAudioFormat())) {
                Main.LOGGER.warn("Audio snippet {} has the wrong audio format.", (Object)((File)snippet.func_76341_a()).getName());
                continue;
            }
            int ts = (int)((Long)snippet.func_76340_b() - this.timestamp);
            audio.insertAt(IOUtils.toByteArray((InputStream)audioInputStream), ts);
            audioInputStream.close();
            bis.close();
            fis.close();
            progress.accept(Float.valueOf(((float)i + 1.0f) / (float)audioSnippets.size()));
        }
        return audio;
    }

    private static class DynamicByteArray {
        private byte[] data;

        public DynamicByteArray() {
            this(0);
        }

        public DynamicByteArray(int initialLength) {
            this.data = new byte[initialLength];
        }

        public DynamicByteArray(byte[] initialData) {
            this.data = initialData;
        }

        public void add(byte[] b, int offset) {
            int max = b.length + offset;
            if (max > this.data.length) {
                byte[] newData = new byte[max];
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
                this.data = newData;
            }
            System.arraycopy(b, 0, this.data, offset, b.length);
        }

        public byte[] getBytes() {
            return this.data;
        }
    }

    private static class RandomAccessAudio {
        private AudioFormat audioFormat;
        private DynamicByteArray data;

        public RandomAccessAudio(AudioFormat audioFormat) {
            this.audioFormat = audioFormat;
            this.data = new DynamicByteArray();
        }

        public void insertAt(byte[] b, int offsetMilliseconds) throws UnsupportedAudioFileException {
            if (this.audioFormat.getFrameSize() == -1) {
                throw new UnsupportedAudioFileException("Frame size not specified");
            }
            if (this.audioFormat.getChannels() == -1) {
                throw new UnsupportedAudioFileException("Channel count not specified");
            }
            if (this.audioFormat.getSampleRate() == -1.0f) {
                throw new UnsupportedAudioFileException("Sample rate not specified");
            }
            int bytesPerMs = (int)this.audioFormat.getSampleRate() / 1000 * this.audioFormat.getFrameSize();
            this.data.add(b, offsetMilliseconds * bytesPerMs);
        }

        public AudioFormat getAudioFormat() {
            return this.audioFormat;
        }

        public byte[] getBytes() {
            return this.data.getBytes();
        }
    }

    private static class AudioChunk {
        private final long timestamp;
        private final ByteArrayOutputStream buffer;

        public AudioChunk(long timestamp) {
            this.timestamp = timestamp;
            this.buffer = new ByteArrayOutputStream();
        }

        public void add(byte[] data) throws IOException {
            this.buffer.write(data);
        }

        public byte[] getBytes() {
            return this.buffer.toByteArray();
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

