/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import com.sun.jna.Pointer;
import de.maxhenkel.voicechat.rnnoise4j.RNNoise;
import de.maxhenkel.voicechat.voice.common.Utils;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public class Denoiser {
    private static final int FRAME_SIZE = 480;
    private final Pointer state = RNNoise.INSTANCE.rnnoise_create(null);

    private Denoiser() {
    }

    public byte[] denoise(byte[] audio) {
        float[] data = Utils.bytesToFloat(audio);
        if (data.length % 480 != 0) {
            throw new IllegalArgumentException("Denoising data frame size is not divisible by 480");
        }
        float[] chunk = new float[480];
        float[] denoisedChunk = new float[480];
        float[] denoised = new float[data.length];
        for (int i = 0; i < data.length / 480; ++i) {
            System.arraycopy(data, 480 * i, chunk, 0, 480);
            RNNoise.INSTANCE.rnnoise_process_frame(this.state, denoisedChunk, chunk);
            System.arraycopy(denoisedChunk, 0, denoised, 480 * i, 480);
        }
        return Utils.floatToBytes(denoised);
    }

    public void close() {
        RNNoise.INSTANCE.rnnoise_destroy(this.state);
    }

    @Nullable
    public static Denoiser createDenoiser() {
        AtomicReference denoiser = new AtomicReference();
        Thread t = new Thread(() -> denoiser.set(new Denoiser()));
        t.start();
        try {
            t.join(1000L);
        }
        catch (InterruptedException e) {
            return null;
        }
        return (Denoiser)denoiser.get();
    }
}

