/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.common;

import de.maxhenkel.voicechat.voice.client.Client;
import de.maxhenkel.voicechat.voice.common.AES;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Server;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import net.minecraft.network.PacketBuffer;

public class NetworkMessage {
    private final long timestamp;
    private Packet<? extends Packet> packet;
    private SocketAddress address;
    private static final Map<Byte, Class<? extends Packet>> packetRegistry = new HashMap<Byte, Class<? extends Packet>>();

    public NetworkMessage(long timestamp, Packet<?> packet) {
        this(timestamp);
        this.packet = packet;
    }

    public NetworkMessage(Packet<?> packet) {
        this(System.currentTimeMillis());
        this.packet = packet;
    }

    private NetworkMessage(long timestamp) {
        this.timestamp = timestamp;
    }

    @Nonnull
    public Packet<? extends Packet> getPacket() {
        return this.packet;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTTL() {
        return this.packet.getTTL();
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public static UnprocessedNetworkMessage readPacket(DatagramSocket socket) throws IOException {
        DatagramPacket packet = new DatagramPacket(new byte[4096], 4096);
        socket.receive(packet);
        return new UnprocessedNetworkMessage(packet, System.currentTimeMillis());
    }

    public static NetworkMessage readPacketClient(DatagramSocket socket, Client client) throws IllegalAccessException, InstantiationException, IOException, InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        DatagramPacket packet = new DatagramPacket(new byte[4096], 4096);
        socket.receive(packet);
        byte[] data = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), packet.getOffset(), data, 0, packet.getLength());
        PacketBuffer b = new PacketBuffer(Unpooled.wrappedBuffer((byte[])data));
        return NetworkMessage.readFromBytes(packet.getSocketAddress(), client.getSecret(), data, System.currentTimeMillis());
    }

    public static NetworkMessage readPacketServer(UnprocessedNetworkMessage msg, Server server) throws IllegalAccessException, InstantiationException, InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        byte[] data = new byte[msg.packet.getLength()];
        System.arraycopy(msg.packet.getData(), msg.packet.getOffset(), data, 0, msg.packet.getLength());
        PacketBuffer b = new PacketBuffer(Unpooled.wrappedBuffer((byte[])data));
        UUID playerID = b.func_179253_g();
        return NetworkMessage.readFromBytes(msg.packet.getSocketAddress(), server.getSecret(playerID), b.func_179251_a(), msg.timestamp);
    }

    private static NetworkMessage readFromBytes(SocketAddress socketAddress, UUID secret, byte[] encryptedPayload, long timestamp) throws InstantiationException, IllegalAccessException, InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        byte[] decrypt = AES.decrypt(secret, encryptedPayload);
        PacketBuffer buffer = new PacketBuffer(Unpooled.wrappedBuffer((byte[])decrypt));
        UUID readSecret = buffer.func_179253_g();
        if (!secret.equals(readSecret)) {
            throw new InvalidKeyException("Secrets do not match");
        }
        byte packetType = buffer.readByte();
        Class<? extends Packet> packetClass = packetRegistry.get(packetType);
        if (packetClass == null) {
            throw new InstantiationException("Could not find packet with ID " + packetType);
        }
        Packet p = packetClass.newInstance();
        NetworkMessage message = new NetworkMessage(timestamp);
        message.address = socketAddress;
        message.packet = p.fromBytes(buffer);
        return message;
    }

    public UUID getSender(Server server) {
        return server.getConnections().values().stream().filter(connection -> connection.getAddress().equals(this.address)).map(ClientConnection::getPlayerUUID).findAny().orElse(null);
    }

    private static byte getPacketType(Packet<? extends Packet> packet) {
        for (Map.Entry<Byte, Class<? extends Packet>> entry : packetRegistry.entrySet()) {
            if (!packet.getClass().equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return -1;
    }

    public byte[] writeClient(Client client) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        byte[] payload = this.write(client.getSecret());
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer((int)(payload.length + 32)));
        buffer.func_179252_a(client.getPlayerUUID());
        buffer.func_179250_a(payload);
        return buffer.array();
    }

    public byte[] write(UUID secret) throws InvalidAlgorithmParameterException, NoSuchPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, BadPaddingException, InvalidKeyException {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        buffer.func_179252_a(secret);
        byte type = NetworkMessage.getPacketType(this.packet);
        if (type < 0) {
            throw new IllegalArgumentException("Packet type not found");
        }
        buffer.writeByte((int)type);
        this.packet.toBytes(buffer);
        return AES.encrypt(secret, buffer.array());
    }

    static {
        packetRegistry.put((byte)0, MicPacket.class);
        packetRegistry.put((byte)1, PlayerSoundPacket.class);
        packetRegistry.put((byte)2, GroupSoundPacket.class);
        packetRegistry.put((byte)3, LocationSoundPacket.class);
        packetRegistry.put((byte)4, AuthenticatePacket.class);
        packetRegistry.put((byte)5, AuthenticateAckPacket.class);
        packetRegistry.put((byte)6, PingPacket.class);
        packetRegistry.put((byte)7, KeepAlivePacket.class);
    }

    public static class UnprocessedNetworkMessage {
        private DatagramPacket packet;
        private long timestamp;

        public UnprocessedNetworkMessage(DatagramPacket packet, long timestamp) {
            this.packet = packet;
            this.timestamp = timestamp;
        }

        public DatagramPacket getPacket() {
            return this.packet;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

