/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.item;

import cofh.core.compat.curios.CuriosProxy;
import cofh.core.util.ProxyUtils;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.item.FluidContainerItemAugmentable;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidReservoirItem
extends FluidContainerItemAugmentable
implements IColorableItem,
IDyeableArmorItem,
IMultiModeItem {
    protected static final int FILL = 0;
    protected static final int EMPTY = 1;

    public FluidReservoirItem(Item.Properties builder, int fluidCapacity) {
        super(builder, fluidCapacity);
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalConfig.storageAugments;
        this.augValidator = ThermalAugmentRules.FLUID_STORAGE_VALIDATOR;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)(this.isActive(stack) ? new TranslationTextComponent("info.cofh_use_sneak_deactivate").func_240699_a_(TextFormatting.DARK_GRAY) : new TranslationTextComponent("info.cofh.use_sneak_activate").func_240699_a_(TextFormatting.DARK_GRAY)));
        tooltip.add((ITextComponent)StringHelper.getTextComponent((String)("info.thermal.reservoir.mode." + this.getMode(stack))).func_240699_a_(TextFormatting.ITALIC));
        this.addIncrementModeChangeTooltip(stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226250_c_((Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (Utils.isClientWorld((World)worldIn) || Utils.isFakePlayer((Entity)entityIn) || !this.isActive(stack)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        for (ItemStack equip : player.func_184209_aF()) {
            if (stack.func_190926_b() || equip.equals(stack)) continue;
            equip.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(c -> this.drainInternal(stack, c.fill(new FluidStack(this.getFluid(stack), Math.min(this.getFluidAmount(stack), 1000)), IFluidHandler.FluidAction.EXECUTE), player.field_71075_bZ.field_75098_d ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
        }
        CuriosProxy.getAllWorn((LivingEntity)player).ifPresent(c -> {
            for (int i = 0; i < c.getSlots(); ++i) {
                ItemStack equip = c.getStackInSlot(i);
                if (stack.func_190926_b() || equip.equals(stack)) continue;
                equip.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).ifPresent(f -> this.drainInternal(stack, f.fill(new FluidStack(this.getFluid(stack), Math.min(this.getFluidAmount(stack), 1000)), IFluidHandler.FluidAction.EXECUTE), player.field_71075_bZ.field_75098_d ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
            }
        });
    }

    protected boolean useDelegate(ItemStack stack, PlayerEntity player, Hand hand) {
        if (Utils.isFakePlayer((Entity)player)) {
            return false;
        }
        if (player.func_226563_dT_()) {
            this.setActive(stack, !this.isActive(stack));
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, this.isActive(stack) ? 0.8f : 0.5f);
            return true;
        }
        if (this.getMode(stack) == 0) {
            return this.doBucketFill(stack, player, hand);
        }
        if (this.getMode(stack) == 1) {
            return this.doBucketEmpty(stack, player, hand);
        }
        return false;
    }

    protected boolean doBucketFill(ItemStack stack, @Nonnull PlayerEntity player, Hand hand) {
        FluidActionResult result;
        if (this.getSpace(stack) < 1000) {
            return false;
        }
        World world = player.func_130014_f_();
        BlockRayTraceResult traceResult = FluidReservoirItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return false;
        }
        if (traceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockPos pos = traceResult.func_216350_a();
        Direction sideHit = traceResult.func_216354_b();
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos, sideHit, stack) && (result = FluidUtil.tryPickUpFluid((ItemStack)stack, (PlayerEntity)player, (World)world, (BlockPos)pos, (Direction)sideHit)).isSuccess()) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, result.getResult());
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
            return true;
        }
        return false;
    }

    protected boolean doBucketEmpty(ItemStack stack, @Nonnull PlayerEntity player, Hand hand) {
        FluidActionResult result;
        BlockPos targetPos;
        if (this.getFluidAmount(stack) < 1000) {
            return false;
        }
        World world = player.func_130014_f_();
        BlockRayTraceResult traceResult = FluidReservoirItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.NONE);
        if (traceResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return false;
        }
        if (traceResult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return false;
        }
        BlockPos pos = traceResult.func_216350_a();
        Direction sideHit = traceResult.func_216354_b();
        if (world.func_175660_a(player, pos) && player.func_175151_a(targetPos = pos.func_177972_a(sideHit), sideHit.func_176734_d(), stack) && (result = FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)targetPos, (ItemStack)stack, (FluidStack)new FluidStack(this.getFluid(stack), 1000))).isSuccess()) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, result.getResult());
                player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
            return true;
        }
        return false;
    }

    protected FluidStack drainInternal(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        return super.drain(container, maxDrain, action);
    }

    public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.getMode(container) != 0) {
            return 0;
        }
        return super.fill(container, resource, action);
    }

    public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        if (this.getMode(container) != 1) {
            return FluidStack.EMPTY;
        }
        return super.drain(container, maxDrain, action);
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), this.getMode(stack) == 0 ? SoundEvents.field_187615_H : SoundEvents.field_191241_J, SoundCategory.PLAYERS, 0.6f, 1.0f);
        ChatHelper.sendIndexedChatMessageToPlayer((PlayerEntity)player, (ITextComponent)new TranslationTextComponent("info.thermal.reservoir.mode." + this.getMode(stack)));
    }

    public int getColor(ItemStack item, int colorIndex) {
        if (colorIndex == 1) {
            CompoundNBT nbt = item.func_179543_a("display");
            return nbt != null && nbt.func_150297_b("color", 99) ? nbt.func_74762_e("color") : 0xFFFFFF;
        }
        return 0xFFFFFF;
    }
}

