/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ClientUtils;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.ChestState;
import xfacthd.framedblocks.common.data.LatchType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedChestModel
extends FramedBlockModel {
    private static final ResourceLocation TEXTURE = new ResourceLocation("framedblocks", "block/framed_chest_lock");
    private final Direction facing;
    private final boolean closed;
    private final LatchType latch;

    public FramedChestModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        this.closed = state.func_177229_b(PropertyHolder.CHEST_STATE) == ChestState.CLOSED || ClientUtils.OPTIFINE_LOADED.get() != false;
        this.latch = (LatchType)((Object)state.func_177229_b(PropertyHolder.LATCH_TYPE));
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
            BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.0625f, 0.0625f, 0.9375f, 0.9375f)) {
                if (topBotQuad.func_178210_d() == Direction.UP) {
                    BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, this.closed ? 0.875f : 0.625f);
                    quadMap.get(null).add(topBotQuad);
                } else {
                    quadMap.get(quad.func_178210_d()).add(topBotQuad);
                }
            }
        } else {
            BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideQuad(sideQuad, 0.0625f, 0.0f, 0.9375f, this.closed ? 0.875f : 0.625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.9375f);
                quadMap.get(null).add(sideQuad);
            }
        }
        if (this.latch == LatchType.CAMO) {
            FramedChestModel.makeChestLatch(quadMap, quad, this.facing);
        }
    }

    public static void makeChestLatch(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction facing) {
        Direction face = quad.func_178210_d();
        BakedQuad copy = ModelUtils.duplicateQuad(quad);
        if (face == facing || face == facing.func_176734_d()) {
            if (BakedQuadTransformer.createSideQuad(copy, 0.4375f, 0.4375f, 0.5625f, 0.6875f)) {
                if (face == facing) {
                    quadMap.get(facing).add(copy);
                } else {
                    BakedQuadTransformer.setQuadPosInFacingDir(copy, 0.0625f);
                    quadMap.get(null).add(copy);
                }
            }
        } else if (face.func_176740_k() == Direction.Axis.Y) {
            if (BakedQuadTransformer.createTopBottomQuad(copy, facing.func_176734_d(), 0.0625f) && BakedQuadTransformer.createTopBottomQuad(copy, facing.func_176746_e(), 0.5625f) && BakedQuadTransformer.createTopBottomQuad(copy, facing.func_176735_f(), 0.5625f)) {
                BakedQuadTransformer.setQuadPosInFacingDir(copy, face == Direction.UP ? 0.6875f : 0.5625f);
                quadMap.get(null).add(copy);
            }
        } else if (BakedQuadTransformer.createSideQuad(copy, 0.0f, 0.4375f, 1.0f, 0.6875f) && BakedQuadTransformer.createVerticalSideQuad(copy, facing.func_176734_d(), 0.0625f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(copy, 0.5625f);
            quadMap.get(null).add(copy);
        }
    }

    @Override
    protected boolean hasAdditionalQuadsInLayer(RenderType layer) {
        return this.latch == LatchType.DEFAULT && layer == RenderType.func_228643_e_();
    }

    @Override
    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, Random rand, IModelData data, RenderType layer) {
        if (!this.closed || this.latch != LatchType.DEFAULT) {
            return;
        }
        List quads = this.baseModel.getQuads(state, null, rand, data);
        for (BakedQuad quad : quads) {
            if (!quad.func_187508_a().func_195668_m().equals((Object)TEXTURE)) continue;
            quadMap.get(null).add(quad);
        }
    }

    public static BlockState itemSource() {
        return ((Block)FBContent.blockFramedChest.get()).func_176223_P();
    }
}

