/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;
import xfacthd.framedblocks.client.model.BakedModelProxy;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.CollapseFace;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedCollapsibleTileEntity;

public class FramedCollapsibleBlockModel
extends BakedModelProxy {
    private final BlockState state;
    private final Int2ObjectMap<CollapsibleModel> MODEL_CACHE = new Int2ObjectOpenHashMap();

    public FramedCollapsibleBlockModel(BlockState state, IBakedModel baseModel) {
        super(baseModel);
        this.state = state;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return this.getModel(extraData).getQuads(state, side, rand, extraData);
    }

    public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
        return this.getModel(data).getParticleTexture(data);
    }

    private CollapsibleModel getModel(IModelData extraData) {
        Integer offsets = (Integer)extraData.getData(FramedCollapsibleTileEntity.OFFSETS);
        int packed = offsets == null ? 0 : offsets;
        return (CollapsibleModel)this.MODEL_CACHE.computeIfAbsent(packed, key -> new CollapsibleModel(this.state, this.baseModel, key));
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof FramedCollapsibleTileEntity) {
            return te.getModelData();
        }
        return tileData;
    }

    private static class CollapsibleModel
    extends FramedBlockModel {
        private final Direction collapsedFace;
        private final float[] vertexPos = new float[4];

        public CollapsibleModel(BlockState state, IBakedModel baseModel, int packedOffsets) {
            super(state, baseModel);
            this.collapsedFace = ((CollapseFace)((Object)state.func_177229_b(PropertyHolder.COLLAPSED_FACE))).toDirection();
            byte[] vertexOffsets = FramedCollapsibleTileEntity.unpackOffsets(packedOffsets);
            for (int i = 0; i < 4; ++i) {
                this.vertexPos[i] = 1.0f - (float)vertexOffsets[i] / 16.0f;
            }
        }

        @Override
        protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
            if (this.collapsedFace == null || quad.func_178210_d() == this.collapsedFace.func_176734_d()) {
                quadMap.get(quad.func_178210_d()).add(quad);
                return;
            }
            if (quad.func_178210_d() == this.collapsedFace) {
                BakedQuad collapsedQuad = ModelUtils.duplicateQuad(quad);
                BakedQuadTransformer.setVertexPosInFacingDir(collapsedQuad, this.vertexPos);
                quadMap.get(null).add(collapsedQuad);
            } else {
                BakedQuad cutQuad = ModelUtils.duplicateQuad(quad);
                if (this.collapsedFace.func_176740_k() == Direction.Axis.Y) {
                    float posTwo;
                    boolean top = this.collapsedFace == Direction.UP;
                    int idxOff = this.getYCollapsedIndexOffset(quad.func_178210_d());
                    float posOne = this.vertexPos[idxOff];
                    if (top) {
                        posTwo = this.vertexPos[(idxOff + 1) % 4];
                    } else {
                        int idxTwo = idxOff - 1;
                        if (idxTwo < 0) {
                            idxTwo = 4 + idxTwo;
                        }
                        posTwo = this.vertexPos[idxTwo % 4];
                    }
                    if (BakedQuadTransformer.createHorizontalSideQuad(cutQuad, !top, posOne, posTwo)) {
                        quadMap.get(quad.func_178210_d()).add(cutQuad);
                    }
                } else if (quad.func_178210_d().func_176740_k() == Direction.Axis.Y) {
                    boolean top = quad.func_178210_d() == Direction.UP;
                    float posOne = this.vertexPos[top ? 0 : 1];
                    float posTwo = this.vertexPos[top ? 3 : 2];
                    if (this.collapsedFace == Direction.NORTH || top && this.collapsedFace == Direction.WEST || !top && this.collapsedFace == Direction.EAST) {
                        float temp = posOne;
                        posOne = posTwo;
                        posTwo = temp;
                    }
                    if (BakedQuadTransformer.createTopBottomQuad(cutQuad, this.collapsedFace, posOne, posTwo)) {
                        quadMap.get(quad.func_178210_d()).add(cutQuad);
                    }
                } else {
                    float posBot;
                    boolean right = this.collapsedFace == cutQuad.func_178210_d().func_176746_e();
                    float posTop = this.vertexPos[right ? 3 : 0];
                    if (BakedQuadTransformer.createVerticalSideQuad(cutQuad, this.collapsedFace, posTop, posBot = this.vertexPos[right ? 2 : 1])) {
                        quadMap.get(quad.func_178210_d()).add(cutQuad);
                    }
                }
            }
        }

        @Override
        protected IBakedModel getCamoModel(BlockState camoState) {
            if (camoState == ((Block)FBContent.blockFramedCube.get()).func_176223_P()) {
                return this.baseModel;
            }
            return super.getCamoModel(camoState);
        }

        @Override
        protected boolean canRenderBaseModelInLayer(RenderType layer) {
            return layer == RenderType.func_228639_c_();
        }

        private int getYCollapsedIndexOffset(Direction quadFace) {
            boolean top = this.collapsedFace == Direction.UP;
            switch (quadFace) {
                case NORTH: {
                    return top ? 3 : 2;
                }
                case EAST: {
                    return top ? 2 : 3;
                }
                case SOUTH: {
                    return top ? 1 : 0;
                }
                case WEST: {
                    return top ? 0 : 1;
                }
            }
            throw new IllegalArgumentException("Invalid facing for y face collapse!");
        }
    }
}

