/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import xfacthd.framedblocks.client.model.FramedBlockModel;
import xfacthd.framedblocks.client.util.BakedQuadTransformer;
import xfacthd.framedblocks.client.util.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.Utils;

public class FramedSlopeSlabModel
extends FramedBlockModel {
    private static final float ANGLE = (float)(90.0 - Math.toDegrees(Math.atan(0.5)));
    private final Direction facing;
    private final boolean top;
    private final boolean topHalf;

    public FramedSlopeSlabModel(BlockState state, IBakedModel baseModel) {
        super(state, baseModel);
        this.facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
        this.top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        this.topHalf = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP_HALF);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.func_178210_d();
        if (face == this.facing.func_176734_d()) {
            BakedQuad slope = FramedSlopeSlabModel.createSlope(quad, this.facing, this.top);
            if (this.topHalf != this.top) {
                BakedQuadTransformer.offsetQuadInDir(slope, this.top ? Direction.DOWN : Direction.UP, 0.5f);
            }
            quadMap.get(null).add(slope);
        } else if (face == this.facing) {
            BakedQuad slabSide = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createHorizontalSideQuad(slabSide, this.topHalf, 0.5f)) {
                quadMap.get(face).add(slabSide);
            }
        } else if (face == this.facing.func_176746_e() || face == this.facing.func_176735_f()) {
            BakedQuad triangle = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideTriangleQuad(triangle, face == this.facing.func_176746_e(), this.top, 0.5f, this.topHalf == this.top ? 0.0f : 0.5f) && (this.topHalf == this.top || BakedQuadTransformer.createHorizontalSideQuad(triangle, !this.top, 0.5f))) {
                quadMap.get(face).add(triangle);
            }
        } else if (this.top && !this.topHalf && face == Direction.UP || !this.top && this.topHalf && face == Direction.DOWN) {
            BakedQuad topBottom = ModelUtils.duplicateQuad(quad);
            BakedQuadTransformer.setQuadPosInFacingDir(topBottom, 0.5f);
            quadMap.get(null).add(topBottom);
        }
    }

    public static BakedQuad createSlope(BakedQuad quad, Direction facing, boolean top) {
        Vector3f origin = new Vector3f(facing == Direction.WEST ? 1.0f : 0.0f, top ? 1.0f : 0.0f, facing == Direction.NORTH ? 1.0f : 0.0f);
        float angle = Utils.isPositive(facing) == top == Utils.isZ(facing) ? -ANGLE : ANGLE;
        BakedQuad slope = ModelUtils.duplicateQuad(quad);
        BakedQuadTransformer.rotateQuadAroundAxis(slope, facing.func_176746_e().func_176740_k(), origin, angle, true);
        return slope;
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedSlopeSlab.get()).func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

