/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xfacthd.framedblocks.client.render.outline.OutlineRender;
import xfacthd.framedblocks.client.util.ClientConfig;
import xfacthd.framedblocks.common.block.IFramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.SlopeType;
import xfacthd.framedblocks.common.util.Utils;

@Mod.EventBusSubscriber(modid="framedblocks", value={Dist.CLIENT})
public class BlockOutlineRenderer {
    private static final Map<BlockType, OutlineRender> OUTLINE_RENDERERS = new HashMap<BlockType, OutlineRender>();

    @SubscribeEvent
    public static void onRenderBlockHighlight(DrawHighlightEvent.HighlightBlock event) {
        if (!ClientConfig.fancyHitboxes) {
            return;
        }
        BlockRayTraceResult result = event.getTarget();
        BlockState state = Minecraft.func_71410_x().field_71441_e.func_180495_p(result.func_216350_a());
        if (!(state.func_177230_c() instanceof IFramedBlock)) {
            return;
        }
        BlockType type = ((IFramedBlock)state.func_177230_c()).getBlockType();
        if (type.hasSpecialHitbox()) {
            MatrixStack mstack = event.getMatrix();
            Vector3d offset = Vector3d.func_237491_b_((Vector3i)result.func_216350_a()).func_178788_d(event.getInfo().func_216785_c());
            IVertexBuilder builder = event.getBuffers().getBuffer(RenderType.func_228659_m_());
            OutlineRender render = OUTLINE_RENDERERS.get((Object)type);
            mstack.func_227860_a_();
            mstack.func_227861_a_(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c);
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            render.rotateMatrix(mstack, state);
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            render.draw(state, (World)Minecraft.func_71410_x().field_71441_e, result.func_216350_a(), mstack, builder);
            mstack.func_227865_b_();
            event.setCanceled(true);
        }
    }

    public static void registerOutlineRender(BlockType type, OutlineRender render) {
        if (!type.hasSpecialHitbox()) {
            throw new IllegalArgumentException(String.format("Type %s doesn't return true from IBlockType#hasSpecialHitbox()", new Object[]{type}));
        }
        OUTLINE_RENDERERS.put(type, render);
    }

    public static void drawSlopeBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        SlopeType type = Utils.getSlopeType(state);
        if (type != SlopeType.HORIZONTAL) {
            if (type == SlopeType.TOP) {
                mstack.func_227861_a_(0.5, 0.5, 0.5);
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
                mstack.func_227861_a_(-0.5, -0.5, -0.5);
            }
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else {
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        }
    }

    public static void drawCornerSlopeBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            if (type.isTop()) {
                mstack.func_227861_a_(0.5, 0.5, 0.5);
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
                mstack.func_227861_a_(-0.5, -0.5, -0.5);
            }
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        } else {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.func_227862_a_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        }
    }

    public static void drawInnerCornerSlopeBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        CornerType type = (CornerType)((Object)state.func_177229_b(PropertyHolder.CORNER_TYPE));
        if (!type.isHorizontal()) {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (type.isTop()) {
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0);
        } else {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            if (!type.isRight()) {
                mstack.func_227862_a_(-1.0f, 1.0f, 1.0f);
            }
            if (type.isTop()) {
                mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            }
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
    }

    public static void drawPrismCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
    }

    public static void drawInnerPrismCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0);
    }

    public static void drawThreewayCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        OutlineRender.drawLine(builder, mstack, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.5, 0.5, 0.5);
    }

    public static void drawInnerThreewayCornerBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        mstack.func_227861_a_(0.5, 0.5, 0.5);
        if (top) {
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
        }
        mstack.func_227861_a_(-0.5, -0.5, -0.5);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 0.5, 0.5, 0.5);
        OutlineRender.drawLine(builder, mstack, 0.5, 0.5, 0.5, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 0.0, 0.5, 0.5, 0.5);
    }

    public static void drawSlopeSlabBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
        boolean topHalf = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP_HALF);
        if (top) {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
        }
        if (topHalf != top) {
            mstack.func_227861_a_(0.0, 0.5, 0.0);
        }
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 0.5, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 0.5, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.5, 1.0, 1.0, 0.5, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.5, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    }

    public static void drawElevatedSlopeSlabBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        if (((Boolean)state.func_177229_b((Property)PropertyHolder.TOP)).booleanValue()) {
            mstack.func_227861_a_(0.5, 0.5, 0.5);
            mstack.func_227862_a_(1.0f, -1.0f, 1.0f);
            mstack.func_227861_a_(-0.5, -0.5, -0.5);
        }
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.5, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.5, 0.0, 1.0, 0.5, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.5, 0.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    }

    public static void drawInverseDoubleSlopeSlabBox(BlockState state, MatrixStack mstack, IVertexBuilder builder) {
        OutlineRender.drawLine(builder, mstack, 0.0, 0.5, 1.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.5, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.5, 0.0, 1.0, 0.5, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.5, 1.0, 1.0, 0.5, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.5, 0.0, 0.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.5, 0.0, 1.0, 1.0, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.5, 1.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        OutlineRender.drawLine(builder, mstack, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0);
        OutlineRender.drawLine(builder, mstack, 1.0, 0.0, 0.0, 1.0, 0.5, 0.0);
    }
}

