/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.CtmPredicate;
import xfacthd.framedblocks.common.util.Utils;

public class FramedElevatedSlopeSlabBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, dir) -> dir == state.func_177229_b((Property)PropertyHolder.FACING_HOR) || (Boolean)state.func_177229_b((Property)PropertyHolder.TOP) != false && dir == Direction.UP || (Boolean)state.func_177229_b((Property)PropertyHolder.TOP) == false && dir == Direction.DOWN;

    public FramedElevatedSlopeSlabBlock() {
        super(BlockType.FRAMED_ELEVATED_SLOPE_SLAB);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.TOP, BlockStateProperties.field_208198_y, PropertyHolder.SOLID, PropertyHolder.GLOWING});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction face = context.func_196000_l();
        Direction facing = Utils.isY(face) ? context.func_195992_f() : face.func_176734_d();
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)facing);
        state = this.withTop(state, context.func_196000_l(), context.func_221532_j());
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shapeBottom = VoxelShapes.func_197872_a((VoxelShape)FramedSlopeSlabBlock.SHAPE_BOTTOM.func_197751_a(0.0, 0.5, 0.0), (VoxelShape)FramedElevatedSlopeSlabBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
        VoxelShape shapeTop = VoxelShapes.func_197872_a((VoxelShape)FramedSlopeSlabBlock.SHAPE_TOP, (VoxelShape)FramedElevatedSlopeSlabBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            boolean top = (Boolean)state.func_177229_b((Property)PropertyHolder.TOP);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, top ? shapeTop : shapeBottom));
        }
        return builder.build();
    }
}

