/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import xfacthd.framedblocks.common.block.AbstractFramedDoubleBlock;
import xfacthd.framedblocks.common.block.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.tileentity.FramedInverseDoubleSlopeSlabTileEntity;
import xfacthd.framedblocks.common.util.Utils;

public class FramedInverseDoubleSlopeSlabBlock
extends AbstractFramedDoubleBlock {
    public FramedInverseDoubleSlopeSlabBlock() {
        super(BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PropertyHolder.FACING_HOR, BlockStateProperties.field_208198_y});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction face = context.func_196000_l();
        Direction facing = Utils.isY(face) ? context.func_195992_f() : face.func_176734_d();
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)PropertyHolder.FACING_HOR, (Comparable)facing);
        return this.withWater(state, (IWorldReader)context.func_195991_k(), context.func_195995_a());
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new FramedInverseDoubleSlopeSlabTileEntity();
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shape = VoxelShapes.func_197872_a((VoxelShape)FramedSlopeSlabBlock.SHAPE_BOTTOM.func_197751_a(0.0, 0.5, 0.0), (VoxelShape)Utils.rotateShape(Direction.NORTH, Direction.SOUTH, FramedSlopeSlabBlock.SHAPE_TOP));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction facing = (Direction)state.func_177229_b((Property)PropertyHolder.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return builder.build();
    }
}

