/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.BookTextParser;
import vazkii.patchouli.client.book.text.TextLayouter;
import vazkii.patchouli.client.book.text.Word;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.book.Book;

public class BookTextRenderer {
    private final Book book;
    private final GuiBook gui;
    private final ITextComponent text;
    private final int x;
    private final int y;
    private final int width;
    private final int lineHeight;
    private final Style baseStyle;
    private List<Word> words;
    private float scale;

    public BookTextRenderer(GuiBook gui, ITextComponent text, int x, int y) {
        this(gui, text, x, y, 116, 9, gui.book.textColor);
    }

    public BookTextRenderer(GuiBook gui, ITextComponent text, int x, int y, int width, int lineHeight, int baseColor) {
        this.book = gui.book;
        this.gui = gui;
        this.text = this.book.i18n && text instanceof StringTextComponent ? new StringTextComponent(I18n.func_135052_a((String)((StringTextComponent)text).func_150265_g(), (Object[])new Object[0])) : text;
        this.x = x;
        this.y = y;
        this.width = width;
        this.lineHeight = lineHeight;
        this.baseStyle = this.book.getFontStyle().func_240718_a_(Color.func_240743_a_((int)baseColor));
        this.build();
    }

    private void build() {
        BookTextParser parser = new BookTextParser(this.gui, this.book, this.x, this.y, this.width, this.lineHeight, this.baseStyle);
        TextLayouter layouter = new TextLayouter(this.gui, this.x, this.y, this.lineHeight, this.width, (PatchouliConfig.TextOverflowMode)((Object)PatchouliConfig.overflowMode.get()));
        layouter.layout(Minecraft.func_71410_x().field_71466_p, parser.parse(this.text));
        this.scale = layouter.getScale();
        this.words = layouter.getWords();
    }

    private double rescale(double in, double origin) {
        return origin + (in - origin) / (double)this.scale;
    }

    public void render(MatrixStack ms, int mouseX, int mouseY) {
        if (!this.words.isEmpty()) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            Style style = this.book.getFontStyle();
            Word first = this.words.get(0);
            ms.func_227860_a_();
            ms.func_227861_a_((double)first.x, (double)first.y, 0.0);
            ms.func_227862_a_(this.scale, this.scale, 1.0f);
            ms.func_227861_a_((double)(-first.x), (double)(-first.y), 0.0);
            int scaledX = (int)this.rescale(mouseX, first.x);
            int scaledY = (int)this.rescale(mouseY, first.y);
            this.words.forEach(word -> word.render(ms, font, style, scaledX, scaledY));
            ms.func_227865_b_();
        }
    }

    public boolean click(double mouseX, double mouseY, int mouseButton) {
        if (!this.words.isEmpty()) {
            Word first = this.words.get(0);
            double scaledX = this.rescale(mouseX, first.x);
            double scaledY = this.rescale(mouseY, first.y);
            for (Word word : this.words) {
                if (!word.click(scaledX, scaledY, mouseButton)) continue;
                return true;
            }
        }
        return false;
    }
}

